/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces;

import de.dagere.peass.config.TestSelectionConfig;
import java.io.File;

public class TraceFileManager {
    public static final String TXT_ENDING = ".txt";
    public static final String ZIP_ENDING = ".zip";
    private final File methodDir;
    private final String shortVersion;
    private final TestSelectionConfig config;

    public TraceFileManager(File methodDir, String shortVersion, TestSelectionConfig config) {
        this.methodDir = methodDir;
        this.shortVersion = shortVersion;
        this.config = config;
    }

    public File getWholeTraceFile() {
        return this.getTraceFile("");
    }

    public File getNocommentTraceFile() {
        return this.getTraceFile("_nocomment");
    }

    public File getMethodTraceFile() {
        return this.getTraceFile("_method");
    }

    public File getMethodExpandedTraceFile() {
        return this.getTraceFile("_method_expanded");
    }

    private File getTraceFile(String variant) {
        File zipCandidate = new File(this.methodDir, this.shortVersion + variant + ZIP_ENDING);
        if (zipCandidate.exists()) {
            return zipCandidate;
        }
        File txtCandidate = new File(this.methodDir, this.shortVersion + variant + TXT_ENDING);
        if (txtCandidate.exists()) {
            return txtCandidate;
        }
        File noEndingCandidate = new File(this.methodDir, this.shortVersion + variant);
        if (noEndingCandidate.exists()) {
            return noEndingCandidate;
        }
        if (this.config.isWriteAsZip()) {
            return zipCandidate;
        }
        return txtCandidate;
    }

    public static File getExistingTraceFile(File methodDir, String shortVersion, String variant) {
        File zipCandidate = new File(methodDir, shortVersion + variant + ZIP_ENDING);
        if (zipCandidate.exists()) {
            return zipCandidate;
        }
        File txtCandidate = new File(methodDir, shortVersion + variant + TXT_ENDING);
        if (txtCandidate.exists()) {
            return txtCandidate;
        }
        File noEndingCandidate = new File(methodDir, shortVersion + variant);
        if (noEndingCandidate.exists()) {
            return noEndingCandidate;
        }
        return zipCandidate;
    }
}

