/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces;

import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.ci.NonIncludedTestRemover;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.KiekerConfig;
import de.dagere.peass.config.parameters.ExecutionConfigMixin;
import de.dagere.peass.dependency.KiekerResultManager;
import de.dagere.peass.dependency.analysis.CalledMethodLoader;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.analysis.data.TraceElement;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.dependency.traces.KiekerFolderUtil;
import de.dagere.peass.dependency.traces.TraceWriter;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.utils.Constants;
import de.dagere.peass.vcs.GitUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import picocli.CommandLine;

@CommandLine.Command(description={"Generates traces without any additional information"}, name="generateTraces")
public class TraceGeneratorStarter
implements Callable<Void> {
    private static final Logger LOG = LogManager.getLogger(TraceGeneratorStarter.class);
    @CommandLine.Mixin
    protected ExecutionConfigMixin executionMixin;
    @CommandLine.Option(names={"-folder", "--folder"}, description={"Folder of the project that should be analyzed"}, required=true)
    protected File projectFolder;
    @CommandLine.Option(names={"-staticSelectionFile", "--staticSelectionFile"}, description={"Path to the staticSelectionFile"})
    protected File staticSelectionFile;
    private ModuleClassMapping mapping;

    public static void main(String[] args) {
        CommandLine commandLine = new CommandLine((Object)new TraceGeneratorStarter());
        commandLine.execute(args);
    }

    @Override
    public Void call() throws Exception {
        StaticTestSelection staticTestSelection = (StaticTestSelection)Constants.OBJECTMAPPER.readValue(this.staticSelectionFile, StaticTestSelection.class);
        String newestVersion = staticTestSelection.getNewestCommit();
        CommitStaticSelection version = staticTestSelection.getCommits().get(newestVersion);
        TestSet tests = version.getTests();
        ExecutionConfig executionConfig = this.executionMixin.getExecutionConfig();
        NonIncludedTestRemover.removeNotIncluded(tests, executionConfig);
        GitUtils.reset(this.projectFolder);
        PeassFolders folders = new PeassFolders(this.projectFolder);
        KiekerResultManager resultsManager = this.runTests(newestVersion, tests, folders, executionConfig);
        LOG.info("Analyzing tests: {}", tests.getTestMethods());
        this.mapping = new ModuleClassMapping(resultsManager.getExecutor());
        for (TestMethodCall testcase : tests.getTestMethods()) {
            this.writeTestcase(newestVersion, folders, resultsManager, testcase);
        }
        return null;
    }

    private KiekerResultManager runTests(String newestVersion, TestSet tests, PeassFolders folders, ExecutionConfig executionConfig) throws IOException, XmlPullParserException, InterruptedException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        KiekerResultManager resultsManager = new KiekerResultManager(folders, executionConfig, new KiekerConfig(true), new EnvironmentVariables(executionConfig.getProperties()));
        resultsManager.executeKoPeMeKiekerRun(tests, newestVersion, folders.getDependencyLogFolder());
        return resultsManager;
    }

    private void writeTestcase(String newestVersion, PeassFolders folders, KiekerResultManager resultsManager, TestMethodCall testcase) throws FileNotFoundException, IOException, XmlPullParserException {
        File moduleResultFolder = KiekerFolderUtil.getModuleResultFolder(folders, (TestCase)testcase);
        File kiekerResultFolder = KiekerFolderUtil.getClazzMethodFolder(testcase, moduleResultFolder)[0];
        long size = FileUtils.sizeOfDirectory((File)kiekerResultFolder);
        long sizeInMB = size / 0x100000L;
        if (sizeInMB < 100L) {
            LOG.debug("Writing " + String.valueOf(testcase));
            ArrayList<TraceElement> shortTrace = new CalledMethodLoader(kiekerResultFolder, this.mapping, new KiekerConfig()).getShortTrace("");
            this.writeTrace(newestVersion, testcase, shortTrace);
        } else {
            LOG.info("Not writing " + String.valueOf(testcase) + " since size is " + sizeInMB + " mb");
        }
    }

    private void writeTrace(String newestCommit, TestMethodCall testcase, List<TraceElement> shortTrace) throws IOException {
        ResultsFolders results = new ResultsFolders(new File("results"), this.projectFolder.getName());
        String shortVersion = TraceWriter.getShortCommit(newestCommit);
        File methodDir = results.getViewMethodDir(newestCommit, testcase);
        File methodExpandedTrace = new File(methodDir, shortVersion + "_method_expanded");
        Files.write(methodExpandedTrace.toPath(), (Iterable<? extends CharSequence>)shortTrace.stream().map(value -> value.toString()).collect(Collectors.toList()), new OpenOption[0]);
    }
}

