/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces;

import com.github.javaparser.ParseException;
import com.github.javaparser.ast.Node;
import de.dagere.nodeDiffDetector.typeFinding.TypeCache;
import de.dagere.nodeDiffDetector.typeFinding.TypeFileFinder;
import de.dagere.peass.config.KiekerConfig;
import de.dagere.peass.dependency.analysis.CalledMethodLoader;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.dependency.analysis.data.TraceElement;
import de.dagere.peass.dependency.traces.PeassSequitur;
import de.dagere.peass.dependency.traces.TraceElementContent;
import de.dagere.peass.dependency.traces.TraceReadUtils;
import de.dagere.peass.dependency.traces.TraceWithMethods;
import de.dagere.requitur.ContentTraceExpander;
import de.dagere.requitur.ReducedTraceElement;
import de.dagere.requitur.RunLengthEncodingSequitur;
import de.dagere.requitur.Sequitur;
import de.dagere.requitur.content.Content;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraceMethodReader {
    public static final String CYCLE_PREFIX = "#Generated$";
    private static final Logger LOG = LogManager.getLogger(TraceMethodReader.class);
    private final File[] clazzFolder;
    private TypeCache typeCache = new TypeCache();
    final TraceWithMethods trace;
    final PeassSequitur seq = new PeassSequitur();

    public TraceMethodReader(List<TraceElement> calls, File ... clazzFolder) throws FileNotFoundException {
        this.clazzFolder = clazzFolder;
        this.trace = this.loadTrace(calls);
    }

    public TraceMethodReader(File traceFolder, ModuleClassMapping mapping, File ... clazzFolder) throws FileNotFoundException {
        ArrayList<TraceElement> calls = new CalledMethodLoader(traceFolder, mapping, new KiekerConfig()).getShortTrace(null);
        this.clazzFolder = clazzFolder;
        this.trace = this.loadTrace(calls);
    }

    private TraceWithMethods loadTrace(List<TraceElement> calls) throws FileNotFoundException {
        LOG.debug("Trace Length: {}", (Object)calls.size());
        this.seq.addTraceElements(calls);
        RunLengthEncodingSequitur runLengthEncodingSequitur = new RunLengthEncodingSequitur((Sequitur)this.seq);
        runLengthEncodingSequitur.reduce();
        List rleTrace = runLengthEncodingSequitur.getReadableRLETrace();
        TraceWithMethods trace = new TraceWithMethods(rleTrace);
        for (ReducedTraceElement traceElement : rleTrace) {
            this.loadMethodSource(trace, traceElement);
        }
        return trace;
    }

    private void loadMethodSource(TraceWithMethods trace, ReducedTraceElement traceElement) throws FileNotFoundException {
        if (traceElement.getValue() instanceof TraceElementContent) {
            TraceElementContent te = (TraceElementContent)traceElement.getValue();
            String clazzFileName = TraceReadUtils.getClassFileName(te);
            File clazzFile = TypeFileFinder.getClazzFile((String)clazzFileName, (File[])this.clazzFolder);
            if (clazzFile == null) {
                clazzFile = this.findAlternativeClassfile(te, clazzFile);
            }
            if (clazzFile != null) {
                Node method = this.typeCache.getMethod(clazzFile, te.toEntity());
                if (method != null) {
                    String commentedMethod = method.toString().replace("\r", "").intern();
                    trace.setElementSource(te, commentedMethod);
                    method.setComment(null);
                    String noCommentMethod = method.toString().replace("\r", "").intern();
                    trace.setElementSourceNoComment(te, noCommentMethod);
                } else {
                    LOG.debug("Not found: " + String.valueOf((Object)te));
                    trace.setElementSource(te, null);
                    trace.setElementSourceNoComment(te, null);
                }
            } else {
                LOG.error("Not found: " + String.valueOf(clazzFile));
            }
        }
    }

    public File findAlternativeClassfile(TraceElementContent te, File clazzFile) throws FileNotFoundException {
        for (File clazzFolderCandidate : this.clazzFolder) {
            String packageName = te.getPackage().replaceAll("\\.", "/");
            File packageFolder = new File(clazzFolderCandidate, packageName);
            if (!packageFolder.exists()) continue;
            for (File candidate : packageFolder.listFiles((FileFilter)new WildcardFileFilter("*.java"))) {
                List clazzes = this.typeCache.getTypes(candidate);
                if (!clazzes.contains(te.getPackagelessClazz())) continue;
                clazzFile = candidate;
            }
        }
        return clazzFile;
    }

    public List<Content> getExpandedTrace() {
        return ContentTraceExpander.expandContentTrace((List)this.seq.getUncompressedTrace(), (Map)this.seq.getRules());
    }

    public TraceWithMethods getTraceWithMethods() {
        return this.trace;
    }

    public static void main(String[] args) throws ParseException, IOException {
        File traceFolder = new File(args[0]);
        File projectFolder = new File(args[1]);
        File[] clazzFolder = new File[]{new File(projectFolder, "src" + File.separator + "main" + File.separator + "java"), new File(projectFolder, "src" + File.separator + "java"), new File(projectFolder, "src" + File.separator + "test" + File.separator + "java"), new File(projectFolder, "src" + File.separator + "test")};
        TraceMethodReader reader = new TraceMethodReader(traceFolder, ModuleClassMapping.SINGLE_MODULE_MAPPING, clazzFolder);
        reader.getTraceWithMethods();
    }
}

