/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces;

import de.dagere.peass.dependency.analysis.data.TraceElement;
import de.dagere.peass.dependency.traces.TraceElementContent;
import java.io.File;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraceReadUtils {
    private static final Logger LOG = LogManager.getLogger(TraceReadUtils.class);
    private static final Pattern findDotPattern = Pattern.compile(".", 16);
    private static final String QUOTE_REPLACEMENT = Matcher.quoteReplacement(File.separator);

    private TraceReadUtils() {
    }

    public static String getClassFileName(TraceElementContent te) {
        String javaClazzName = te.getClazz();
        String clazzFilePart = findDotPattern.matcher(javaClazzName).replaceAll(QUOTE_REPLACEMENT);
        int indexOf = clazzFilePart.indexOf("$");
        if (indexOf != -1) {
            clazzFilePart = clazzFilePart.substring(0, indexOf);
        }
        String clazzFileName = clazzFilePart + ".java";
        return clazzFileName;
    }

    public static boolean traceElementsEquals(TraceElement currentTraceElement, TraceElement samePredecessorCandidate) {
        return samePredecessorCandidate.getClazz().equals(currentTraceElement.getClazz()) && samePredecessorCandidate.getMethod().equals(currentTraceElement.getMethod()) && Arrays.equals(samePredecessorCandidate.getParameterTypes(), currentTraceElement.getParameterTypes());
    }
}

