/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces;

import de.dagere.peass.dependency.traces.TraceElementContent;
import de.dagere.requitur.ReducedTraceElement;
import de.dagere.requitur.content.Content;
import de.dagere.requitur.content.RuleContent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TraceWithMethods {
    private final List<ReducedTraceElement> elements;
    private final Map<TraceElementContent, String> methods = new HashMap<TraceElementContent, String>();
    private final Map<TraceElementContent, String> methodsWithoutComment = new HashMap<TraceElementContent, String>();

    public TraceWithMethods(List<ReducedTraceElement> rleTrace) {
        this.elements = rleTrace;
    }

    public void setElementSource(TraceElementContent traceElement, String method) {
        this.methods.put(traceElement, method);
    }

    public void setElementSourceNoComment(TraceElementContent traceElement, String method) {
        this.methodsWithoutComment.put(traceElement, method);
    }

    public Content getTraceElement(int position) {
        ReducedTraceElement reducedTraceElement = this.elements.get(position);
        return reducedTraceElement.getValue();
    }

    public int getTraceOccurences(int position) {
        ReducedTraceElement reducedTraceElement = this.elements.get(position);
        return reducedTraceElement.getOccurences();
    }

    public String getMethod(int position) {
        ReducedTraceElement method = this.elements.get(position);
        return this.methods.get(method.getValue());
    }

    public int getLength() {
        return this.elements.size();
    }

    public String getNocommentTrace() {
        Map<TraceElementContent, String> currentSource = this.methodsWithoutComment;
        return this.getTraceString(currentSource);
    }

    public String getWholeTrace() {
        Map<TraceElementContent, String> currentSource = this.methods;
        return this.getTraceString(currentSource);
    }

    private String getTraceString(Map<TraceElementContent, String> currentSource) {
        StringBuilder result = new StringBuilder();
        LinkedList<Integer> currentDepth = new LinkedList<Integer>();
        for (ReducedTraceElement te : this.elements) {
            LinkedList<Integer> newDepth = new LinkedList<Integer>();
            String spaceString = this.getSpaceString(currentDepth, newDepth);
            result.append(spaceString);
            currentDepth = newDepth;
            if (te.getOccurences() != 1) {
                result.append(te.getOccurences());
                result.append(" x ");
            }
            result.append(te.getValue().toString());
            result.append("\n");
            if (te.getValue() instanceof RuleContent) {
                int count = ((RuleContent)te.getValue()).getCount();
                currentDepth.add(count);
                continue;
            }
            if (!(te.getValue() instanceof TraceElementContent) || currentSource == null) continue;
            this.writeMethodSource(currentSource, result, te, spaceString);
        }
        return result.toString();
    }

    private void writeMethodSource(Map<TraceElementContent, String> currentSource, StringBuilder result, ReducedTraceElement te, String spaceString) {
        TraceElementContent traceContent = (TraceElementContent)te.getValue();
        String source = currentSource.get((Object)traceContent);
        if (source != null) {
            result.append(spaceString);
            result.append(source.replaceAll("\n", "\n" + spaceString));
            result.append("\n");
        }
    }

    private String getSpaceString(List<Integer> currentDepth, List<Integer> newDepth) {
        Object spaceString = "";
        for (Integer depth : currentDepth) {
            spaceString = (String)spaceString + " ";
            if (depth <= 1) continue;
            newDepth.add(depth - 1);
        }
        return spaceString;
    }

    public String getTraceMethods() {
        return this.toString();
    }

    public String toString() {
        return this.getTraceString(null);
    }

    public void append(TraceWithMethods additionalTrace) {
        this.elements.addAll(additionalTrace.elements);
        this.methods.putAll(additionalTrace.methods);
        this.methodsWithoutComment.putAll(additionalTrace.methodsWithoutComment);
    }
}

