/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces;

import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.TestSelectionConfig;
import de.dagere.peass.dependency.traces.TraceFileManager;
import de.dagere.peass.dependency.traces.TraceFileMapping;
import de.dagere.peass.dependency.traces.TraceMethodReader;
import de.dagere.peass.dependency.traces.TraceWithMethods;
import de.dagere.peass.dependency.traces.coverage.TraceCallSummary;
import de.dagere.peass.dependency.traces.coverage.TraceSummaryTransformer;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.utils.Constants;
import de.dagere.requitur.content.RuleContent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraceWriter {
    private static final Logger LOG = LogManager.getLogger(TraceWriter.class);
    private final String version;
    private final TestMethodCall testcase;
    private final ResultsFolders resultsFolders;
    private final TraceFileMapping traceFileMapping;
    private final TestSelectionConfig testSelectionConfig;

    public TraceWriter(String version, TestMethodCall testcase, ResultsFolders resultsFolders, TraceFileMapping traceFileMapping, TestSelectionConfig testSelectionConfig) {
        this.version = version;
        this.testcase = testcase;
        this.resultsFolders = resultsFolders;
        this.traceFileMapping = traceFileMapping;
        this.testSelectionConfig = testSelectionConfig;
    }

    public void writeTrace(String commitCurrent, long sizeInMB, TraceMethodReader traceMethodReader, TraceWithMethods trace) throws IOException {
        File methodDir = this.resultsFolders.getViewMethodDir(this.version, this.testcase);
        String shortCommit = TraceWriter.getShortCommit(commitCurrent);
        File methodTrace = this.writeTraces(sizeInMB, traceMethodReader, trace, methodDir, shortCommit);
        LOG.debug("Datei {} existiert: {}", (Object)methodTrace.getAbsolutePath(), (Object)methodTrace.exists());
    }

    public static String getShortCommit(String versionCurrent) {
        Object shortVersion = versionCurrent.substring(0, 6);
        if (versionCurrent.endsWith("~1")) {
            shortVersion = (String)shortVersion + "~1";
        }
        return shortVersion;
    }

    private File writeTraces(long sizeInMB, TraceMethodReader traceMethodReader, TraceWithMethods trace, File methodDir, String shortVersion) throws IOException {
        TraceFileManager fileManager = new TraceFileManager(methodDir, shortVersion, this.testSelectionConfig);
        this.traceFileMapping.addTraceFile(this.testcase, fileManager.getWholeTraceFile());
        this.writeStringToFile(fileManager.getWholeTraceFile(), trace.getWholeTrace(), StandardCharsets.UTF_8);
        this.writeStringToFile(fileManager.getNocommentTraceFile(), trace.getNocommentTrace(), StandardCharsets.UTF_8);
        this.writeStringToFile(fileManager.getMethodTraceFile(), trace.getTraceMethods(), StandardCharsets.UTF_8);
        if (sizeInMB < 5L) {
            this.writeExpandedTrace(traceMethodReader, fileManager);
        } else {
            LOG.debug("Do not write expanded trace - size: {} MB", (Object)sizeInMB);
        }
        File summaryFile = new File(methodDir, shortVersion + "_summary.json");
        TraceCallSummary traceSummary = TraceSummaryTransformer.transform(this.testcase, traceMethodReader.getExpandedTrace());
        Constants.OBJECTMAPPER.writeValue(summaryFile, (Object)traceSummary);
        return fileManager.getMethodTraceFile();
    }

    private void writeExpandedTrace(TraceMethodReader traceMethodReader, TraceFileManager fileManager) throws IOException, FileNotFoundException {
        try (ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(fileManager.getMethodExpandedTraceFile()));
             WritableByteChannel channel = Channels.newChannel(zipStream);){
            ZipEntry entry = new ZipEntry("trace.txt");
            zipStream.putNextEntry(entry);
            traceMethodReader.getExpandedTrace().stream().filter(value -> !(value instanceof RuleContent)).map(value -> value.toString()).forEach(line -> {
                ByteBuffer bytebuffer = StandardCharsets.UTF_8.encode((String)line);
                try {
                    channel.write(bytebuffer);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public void writeStringToFile(File goalFile, String trace, Charset charset) throws FileNotFoundException, IOException {
        block23: {
            if (goalFile.getName().endsWith(".zip")) {
                ByteBuffer bytebuffer = charset.encode(trace);
                try (ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(goalFile));
                     WritableByteChannel channel = Channels.newChannel(zipStream);){
                    ZipEntry entry = new ZipEntry("trace.txt");
                    zipStream.putNextEntry(entry);
                    channel.write(bytebuffer);
                    break block23;
                }
            }
            ByteBuffer bytebuffer = charset.encode(trace);
            try (FileOutputStream outputStream = new FileOutputStream(goalFile);
                 WritableByteChannel channel = Channels.newChannel(outputStream);){
                channel.write(bytebuffer);
            }
        }
    }
}

