/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces.coverage;

import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.peass.dependency.traces.coverage.CoverageSelectionCommit;
import de.dagere.peass.dependency.traces.coverage.TraceCallSummary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CoverageBasedSelector {
    private static final Logger LOG = LogManager.getLogger(CoverageBasedSelector.class);

    public static CoverageSelectionCommit selectBasedOnCoverage(List<TraceCallSummary> summaries, Set<Type> changes) {
        LinkedList<TraceCallSummary> copiedSummaries = new LinkedList<TraceCallSummary>(summaries);
        HashSet<Type> copiedChanges = new HashSet<Type>(changes);
        boolean changed = true;
        CoverageSelectionCommit resultingInfo = new CoverageSelectionCommit();
        LOG.debug("Searching CBS");
        while (copiedSummaries.size() > 0 && copiedChanges.size() > 0 && changed) {
            changed = false;
            TraceCallSummary selected = CoverageBasedSelector.selectMaximumCalled(copiedChanges, copiedSummaries);
            LOG.debug("Selected: {}", (Object)selected);
            if (selected == null) continue;
            selected.setSelected(true);
            resultingInfo.getTestcases().put(selected.getTestcase(), selected);
            copiedSummaries.remove(selected);
            Iterator iterator = copiedSummaries.iterator();
            while (iterator.hasNext()) {
                TraceCallSummary current = (TraceCallSummary)iterator.next();
                if (!current.getTestcase().equals((Object)selected.getTestcase())) continue;
                iterator.remove();
            }
            LOG.debug("Selected: {} with score {}", (Object)selected.getTestcase(), (Object)selected.getOverallScore());
            changed = CoverageBasedSelector.removeUnneededChanges(copiedChanges, changed, selected);
        }
        LOG.debug("Remaining changes: {}", copiedChanges);
        CoverageBasedSelector.setRemainingCallSums(copiedChanges, copiedSummaries);
        CoverageBasedSelector.addNotSelectedSummaryInfos(copiedSummaries, resultingInfo);
        return resultingInfo;
    }

    private static void setRemainingCallSums(Set<Type> changes, List<TraceCallSummary> copiedSummaries) {
        for (TraceCallSummary summary : copiedSummaries) {
            int callSum = CoverageBasedSelector.getCallSum(changes, summary);
            summary.setOverallScore(callSum);
        }
    }

    private static void addNotSelectedSummaryInfos(List<TraceCallSummary> copiedSummaries, CoverageSelectionCommit resultingInfo) {
        for (TraceCallSummary leftSummary : copiedSummaries) {
            LOG.debug("Adding unselected test: {} score: {}", (Object)leftSummary.getTestcase(), (Object)leftSummary.getOverallScore());
            leftSummary.setSelected(false);
            resultingInfo.getTestcases().put(leftSummary.getTestcase(), leftSummary);
        }
    }

    private static boolean removeUnneededChanges(Set<Type> changes, boolean changed, TraceCallSummary selected) {
        Iterator<Type> changeIterator = changes.iterator();
        while (changeIterator.hasNext()) {
            Type change = changeIterator.next();
            String currentChangeSignature = change.toString();
            if (change instanceof MethodCall) {
                if (!selected.getCallCounts().containsKey(currentChangeSignature) || selected.getCallCounts().get(currentChangeSignature) <= 0) continue;
                changeIterator.remove();
                changed = true;
                continue;
            }
            boolean used = false;
            for (Map.Entry<String, Integer> callCount : selected.getCallCounts().entrySet()) {
                String signaturePrefix = change.toString() + "#";
                LOG.trace("Testing: {} vs {}", (Object)signaturePrefix, (Object)callCount.getKey());
                if (!callCount.getKey().startsWith(signaturePrefix)) continue;
                used = true;
            }
            if (!used) continue;
            changeIterator.remove();
            changed = true;
        }
        return changed;
    }

    private static TraceCallSummary selectMaximumCalled(Set<Type> changes, List<TraceCallSummary> copiedSummaries) {
        TraceCallSummary selected = copiedSummaries.get(0);
        int selectedCallSum = CoverageBasedSelector.getCallSum(changes, selected);
        selected.setOverallScore(selectedCallSum);
        LOG.debug("Searching in {} summaries", (Object)copiedSummaries.size());
        for (TraceCallSummary current : copiedSummaries) {
            int currentCallSum = CoverageBasedSelector.getCallSum(changes, current);
            if (currentCallSum <= selectedCallSum) continue;
            selectedCallSum = currentCallSum;
            selected = current;
            selected.setOverallScore(currentCallSum);
        }
        if (selectedCallSum > 0) {
            return selected;
        }
        return null;
    }

    private static int getCallSum(Set<Type> changes, TraceCallSummary summary) {
        summary.getSelectedChanges().clear();
        int currentCallSum = 0;
        LOG.debug("Changes: {} Test: {}", (Object)changes.size(), (Object)summary.getTestcase());
        LOG.trace("Trace Callcounts: {}", summary.getCallCounts().keySet());
        for (Type change : changes) {
            String changeSignature = change.toString();
            LOG.trace("Change signature: {}", (Object)changeSignature);
            if (change instanceof MethodCall) {
                currentCallSum = CoverageBasedSelector.addExactCallCount(summary, currentCallSum, changeSignature);
                continue;
            }
            currentCallSum = CoverageBasedSelector.addClassbasedCallCount(summary, currentCallSum, changeSignature);
        }
        LOG.debug("Sum: " + currentCallSum);
        return currentCallSum;
    }

    private static int addClassbasedCallCount(TraceCallSummary summary, int currentCallSum, String changeSignature) {
        LOG.trace("Call counts: {}", (Object)summary.getCallCounts().size());
        for (Map.Entry<String, Integer> callCount : summary.getCallCounts().entrySet()) {
            String signaturePrefix = changeSignature + "#";
            LOG.trace("Testing: {} vs {}", (Object)signaturePrefix, (Object)callCount.getKey());
            if (!callCount.getKey().startsWith(signaturePrefix)) continue;
            currentCallSum += callCount.getValue().intValue();
            summary.getSelectedChanges().add(callCount.getKey());
        }
        return currentCallSum;
    }

    private static int addExactCallCount(TraceCallSummary summary, int currentCallSum, String changeSignature) {
        if (summary.getCallCounts().containsKey(changeSignature)) {
            currentCallSum += summary.getCallCounts().get(changeSignature).intValue();
            summary.getSelectedChanges().add(changeSignature);
        }
        return currentCallSum;
    }
}

