/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces.coverage;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.dependency.traces.TraceFileMapping;
import de.dagere.peass.dependency.traces.coverage.CoverageBasedSelector;
import de.dagere.peass.dependency.traces.coverage.CoverageSelectionCommit;
import de.dagere.peass.dependency.traces.coverage.CoverageSelectionInfo;
import de.dagere.peass.dependency.traces.coverage.TraceCallSummary;
import de.dagere.peass.dependency.traces.diff.TraceFileUtil;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CoverageSelectionExecutor {
    private static final Logger LOG = LogManager.getLogger(CoverageSelectionExecutor.class);
    private final TraceFileMapping mapping;
    private final ExecutionData coverageBasedSelection;
    private final CoverageSelectionInfo coverageSelectionInfo;

    public CoverageSelectionExecutor(TraceFileMapping mapping, ExecutionData coverageBasedSelection, CoverageSelectionInfo coverageSelectionInfo) {
        this.mapping = mapping;
        this.coverageBasedSelection = coverageBasedSelection;
        this.coverageSelectionInfo = coverageSelectionInfo;
    }

    public void generateCoverageBasedSelection(String commit, CommitStaticSelection newCommitSelection, TestSet dynamicallySelected) throws IOException {
        List<TraceCallSummary> summaries = this.getSummaries(dynamicallySelected);
        for (Type change : newCommitSelection.getChangedClazzes().keySet()) {
            LOG.info("Change: {}", (Object)change.toString());
            if (!(change instanceof MethodCall)) continue;
            LOG.info("Parameters: {}", (Object)((MethodCall)change).getParametersPrintable());
        }
        CoverageSelectionCommit selected = CoverageBasedSelector.selectBasedOnCoverage(summaries, newCommitSelection.getChangedClazzes().keySet());
        for (TraceCallSummary traceCallSummary : selected.getTestcases().values()) {
            if (!traceCallSummary.isSelected()) continue;
            this.coverageBasedSelection.addCall(commit, traceCallSummary.getTestcase());
        }
        this.coverageSelectionInfo.getCommits().put(commit, selected);
    }

    private List<TraceCallSummary> getSummaries(TestSet dynamicallySelected) throws IOException, StreamReadException, DatabindException {
        LinkedList<TraceCallSummary> summaries = new LinkedList<TraceCallSummary>();
        for (TestCase testCase : dynamicallySelected.getTestMethods()) {
            List<File> traceFiles = this.mapping.getTestcaseMap(testCase);
            if (traceFiles != null && traceFiles.size() > 1) {
                File oldFile = new File(TraceFileUtil.getNameFromFile(traceFiles.get(0)) + "_summary.json");
                File newFile = new File(TraceFileUtil.getNameFromFile(traceFiles.get(1)) + "_summary.json");
                TraceCallSummary oldSummary = (TraceCallSummary)Constants.OBJECTMAPPER.readValue(oldFile, TraceCallSummary.class);
                TraceCallSummary newSummary = (TraceCallSummary)Constants.OBJECTMAPPER.readValue(newFile, TraceCallSummary.class);
                summaries.add(oldSummary);
                summaries.add(newSummary);
                LOG.info("Found traces for {}", (Object)testCase);
                continue;
            }
            LOG.info("Trace files missing for {}", (Object)testCase);
        }
        return summaries;
    }
}

