/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces.diff;

import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.dependency.traces.TraceFileMapping;
import de.dagere.peass.dependency.traces.diff.DiffUtilJava;
import de.dagere.peass.dependency.traces.diff.DiffUtilUnix;
import de.dagere.peass.dependency.traces.diff.TraceFileUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiffFileGenerator {
    private static final Logger LOG = LogManager.getLogger(DiffFileGenerator.class);
    private final File diffFolder;
    private final boolean unixDiffAvailable;

    public DiffFileGenerator(File diffFolder) {
        this.diffFolder = diffFolder;
        this.unixDiffAvailable = DiffUtilUnix.isAvailable();
        if (!this.unixDiffAvailable) {
            LOG.warn("Warning: Unix Diff tool not found! Consider installing it, since using java difflib as a replacement will significantly slow down processing.");
        }
    }

    public void generateAllDiffs(String commit, CommitStaticSelection newCommitInfo, TraceFileMapping mapping, ExecutionData executionResult) throws IOException {
        for (TestMethodCall testcase : newCommitInfo.getTests().getTestMethods()) {
            boolean tracesChanged = this.tracesChanged(testcase, mapping);
            if (!tracesChanged) continue;
            this.generateDiffFiles(testcase, mapping);
            executionResult.addCall(commit, testcase);
        }
    }

    public boolean tracesChanged(TestMethodCall testcase, TraceFileMapping traceFileMap) throws IOException {
        List<File> traceFiles = traceFileMap.getTestcaseMap((TestCase)testcase);
        if (traceFiles != null) {
            LOG.debug("Trace-Files: {}", traceFiles);
            if (traceFiles.size() > 1) {
                boolean isDifferent;
                String secondName;
                File newFile;
                String firstName = TraceFileUtil.getNameFromFile(traceFiles.get(0));
                File oldFile = new File(firstName + "_nocomment.txt");
                if (!oldFile.exists()) {
                    oldFile = new File(firstName + "_nocomment.zip");
                }
                if (!(newFile = new File((secondName = TraceFileUtil.getNameFromFile(traceFiles.get(1))) + "_nocomment.txt")).exists()) {
                    newFile = new File(secondName + "_nocomment.zip");
                }
                if (this.unixDiffAvailable) {
                    File oldFileUnzipped = this.eventuallUnzip(oldFile);
                    File newFileUnzipped = this.eventuallUnzip(newFile);
                    isDifferent = DiffUtilUnix.isDifferentDiff(oldFileUnzipped, newFileUnzipped);
                    this.eventuallDeleteUnzipped(oldFile, newFile, oldFileUnzipped, newFileUnzipped);
                } else {
                    isDifferent = DiffUtilJava.isDifferentDiff(oldFile, newFile);
                }
                if (isDifferent) {
                    LOG.info("Trace changed.");
                    return true;
                }
                LOG.info("No change; traces equal.");
                return false;
            }
            LOG.info("Traces not existing: {}", (Object)testcase);
            return false;
        }
        LOG.info("Traces not existing: {}", (Object)testcase);
        return false;
    }

    private void eventuallDeleteUnzipped(File oldFile, File newFile, File oldFileUnzipped, File newFileUnzipped) {
        if (oldFile.getName().endsWith(".zip")) {
            oldFileUnzipped.delete();
        }
        if (newFile.getName().endsWith(".zip")) {
            newFileUnzipped.delete();
        }
    }

    private File eventuallUnzip(File oldFile) {
        File oldFileUnzipped = oldFile.getName().endsWith(".zip") ? TraceFileUtil.unzip(oldFile) : oldFile;
        return oldFileUnzipped;
    }

    public void generateDiffFiles(TestMethodCall testcase, TraceFileMapping traceFileMap) throws IOException {
        long size = FileUtils.sizeOfDirectory((File)this.diffFolder);
        long sizeInMB = size / 0x100000L;
        LOG.debug("Filesize: {} ({})", (Object)sizeInMB, (Object)size);
        List<File> traceFiles = traceFileMap.getTestcaseMap((TestCase)testcase);
        this.createAllDiffs(testcase, traceFiles);
    }

    private void createAllDiffs(TestMethodCall testcase, List<File> traceFiles) throws IOException {
        String testcaseName = testcase.getShortClazz() + "#" + testcase.getMethod();
        File firstFile = traceFiles.get(1);
        String ending = TraceFileUtil.getEndingFromFile(firstFile);
        if (this.unixDiffAvailable) {
            DiffUtilUnix.generateDiffFile(new File(this.diffFolder, testcaseName + ending), traceFiles, "");
            DiffUtilUnix.generateDiffFile(new File(this.diffFolder, testcaseName + "_method" + ending), traceFiles, "_method");
            DiffUtilUnix.generateDiffFile(new File(this.diffFolder, testcaseName + "_nocomment" + ending), traceFiles, "_nocomment");
            DiffUtilUnix.generateDiffFile(new File(this.diffFolder, testcaseName + "_method_expanded" + ending), traceFiles, "_method_expanded");
        } else {
            DiffUtilJava.generateDiffFile(new File(this.diffFolder, testcaseName + ending), traceFiles, "");
            DiffUtilJava.generateDiffFile(new File(this.diffFolder, testcaseName + "_method" + ending), traceFiles, "_method");
            DiffUtilJava.generateDiffFile(new File(this.diffFolder, testcaseName + "_nocomment" + ending), traceFiles, "_nocomment");
            DiffUtilJava.generateDiffFile(new File(this.diffFolder, testcaseName + "_method_expanded" + ending), traceFiles, "_method_expanded");
        }
    }
}

