/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces.diff;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.Patch;
import com.github.difflib.text.DiffRow;
import com.github.difflib.text.DiffRowGenerator;
import de.dagere.peass.dependency.traces.diff.TraceFileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiffUtilJava {
    private static final Logger LOG = LogManager.getLogger(DiffUtilJava.class);

    public static void generateDiffFile(File goalFile, List<File> traceFiles, String appendix) throws IOException {
        String ending = TraceFileUtil.getEndingFromFile(goalFile);
        File file1 = new File(TraceFileUtil.getNameFromFile(traceFiles.get(0)) + appendix + ending);
        File file2 = new File(TraceFileUtil.getNameFromFile(traceFiles.get(1)) + appendix + ending);
        if (file1.exists() && file2.exists()) {
            int length = 100;
            List<String> file1text = TraceFileUtil.getText(file1);
            List<String> file2text = TraceFileUtil.getText(file2);
            DiffRowGenerator diffRowGenerator = DiffRowGenerator.create().build();
            List diffRows = diffRowGenerator.generateDiffRows(file1text, file2text);
            DiffUtilJava.writeDiff(goalFile, length, diffRows);
        } else {
            LOG.error("Not both log files {} ({}) {} ({}) existed. ", (Object)file1, (Object)file1.exists(), (Object)file2, (Object)file2.exists());
        }
    }

    private static void writeDiff(File goalFile, int length, List<DiffRow> diffRows) throws IOException {
        StringBuilder resultBuilder = DiffUtilJava.getDiff(length, diffRows);
        String result = resultBuilder.toString();
        if (goalFile.getName().endsWith(".zip")) {
            TraceFileUtil.writeZippedOutput(goalFile, result);
        } else {
            try (FileWriter fw = new FileWriter(goalFile);){
                fw.write(result);
            }
        }
    }

    private static StringBuilder getDiff(int length, List<DiffRow> diffRows) {
        StringBuilder resultBuilder = new StringBuilder();
        for (DiffRow row : diffRows) {
            String newLine;
            String oldLine;
            if (row.getOldLine().equals(row.getNewLine())) {
                oldLine = DiffUtilJava.fillToLength(length, row.getOldLine());
                newLine = DiffUtilJava.fillToLength(length, row.getNewLine());
                resultBuilder.append(oldLine + "   " + newLine + "\n");
                continue;
            }
            oldLine = DiffUtilJava.fillToLength(length, row.getOldLine());
            newLine = DiffUtilJava.fillToLength(length, row.getNewLine());
            resultBuilder.append(oldLine + " | " + newLine + "\n");
        }
        return resultBuilder;
    }

    private static String fillToLength(int length, String oldLine) {
        if (((String)oldLine).length() < length) {
            StringBuffer buffer = new StringBuffer();
            int missingSpaces = length - ((String)oldLine).length();
            for (int i = 0; i < missingSpaces; ++i) {
                buffer.append(' ');
            }
            oldLine = (String)oldLine + buffer.toString();
        } else {
            oldLine = ((String)oldLine).substring(0, length);
        }
        return oldLine;
    }

    public static boolean isDifferentDiff(File file1, File file2) throws IOException {
        Patch<String> patch = DiffUtilJava.getPatch(file1, file2);
        return patch.getDeltas().size() > 0;
    }

    private static Patch<String> getPatch(File file1, File file2) throws IOException {
        List<String> file1text = TraceFileUtil.getText(file1);
        List<String> file2text = TraceFileUtil.getText(file2);
        Patch patch = DiffUtils.diff(file1text, file2text);
        return patch;
    }
}

