/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces.diff;

import de.dagere.peass.dependency.traces.diff.TraceFileUtil;
import de.dagere.peass.utils.StreamGobbler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class DiffUtilUnix {
    public static void generateDiffFile(File goalFile, List<File> traceFiles, String appendix) throws IOException {
        String ending = TraceFileUtil.getEndingFromFile(goalFile);
        if (".txt".equals(ending)) {
            File file1 = new File(TraceFileUtil.getNameFromFile(traceFiles.get(0)) + appendix + ending);
            File file2 = new File(TraceFileUtil.getNameFromFile(traceFiles.get(1)) + appendix + ending);
            DiffUtilUnix.generateDiff(goalFile, file1, file2);
        } else if (".zip".equals(ending)) {
            File zipFile1 = new File(TraceFileUtil.getNameFromFile(traceFiles.get(0)) + appendix + ending);
            File zipFile2 = new File(TraceFileUtil.getNameFromFile(traceFiles.get(1)) + appendix + ending);
            if (zipFile1.exists() && zipFile2.exists()) {
                File file1 = TraceFileUtil.unzip(zipFile1);
                File file2 = TraceFileUtil.unzip(zipFile2);
                File interimGoalFile = new File(TraceFileUtil.getNameFromFile(goalFile) + ".txt");
                DiffUtilUnix.generateDiff(interimGoalFile, file1, file2);
                file1.delete();
                file2.delete();
                String diff = FileUtils.readFileToString((File)interimGoalFile, (Charset)StandardCharsets.UTF_8);
                File finalGoalFile = new File(TraceFileUtil.getNameFromFile(goalFile) + ".zip");
                TraceFileUtil.writeZippedOutput(finalGoalFile, diff);
                interimGoalFile.delete();
            }
        }
    }

    private static void generateDiff(File goalFile, File file1, File file2) throws IOException {
        ProcessBuilder processBuilder2 = new ProcessBuilder("diff", "--minimal", "--ignore-all-space", "-y", "-W", "200", file1.getAbsolutePath(), file2.getAbsolutePath());
        Process p2 = processBuilder2.start();
        String result2 = StreamGobbler.getFullProcess(p2, false);
        try {
            int exitCode = p2.waitFor();
            if (exitCode > 1) {
                throw new RuntimeException("diff did not work correctly " + result2);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        try (FileWriter fw = new FileWriter(goalFile);){
            fw.write(result2);
        }
    }

    public static String getDiff(File file1, File file2) {
        try {
            ProcessBuilder processBuilder2 = new ProcessBuilder("diff", "--ignore-all-space", file1.getAbsolutePath(), file2.getAbsolutePath());
            Process checkDiff = processBuilder2.start();
            String isDifferent = StreamGobbler.getFullProcess(checkDiff, false);
            return isDifferent;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isAvailable() {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("diff", "--version");
            Process process = processBuilder.start();
            StreamGobbler.showFullProcess(process);
            int returnCode = process.waitFor();
            return returnCode == 0;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isDifferentDiff(File oldFile, File newFile) {
        return DiffUtilUnix.getDiff(oldFile, newFile).length() > 0;
    }
}

