/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces.diff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;

public class TraceFileUtil {
    public static String getEndingFromFile(File firstFile) {
        String ending;
        if (firstFile.getName().endsWith(".txt")) {
            ending = ".txt";
        } else if (firstFile.getName().endsWith(".zip")) {
            ending = ".zip";
        } else {
            throw new RuntimeException("Unexpected ending: " + String.valueOf(firstFile));
        }
        return ending;
    }

    public static String getNameFromFile(File file) {
        return file.getAbsolutePath().replace(".txt", "").replace(".zip", "");
    }

    public static File unzip(File zipFile) {
        try {
            int len;
            byte[] buffer = new byte[1024];
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry zipEntry = zis.getNextEntry();
            File destDir = zipFile.getParentFile();
            File txtTraceFile = new File(destDir, zipFile.getName().replace(".zip", ".txt"));
            FileOutputStream fos = new FileOutputStream(txtTraceFile);
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            zis.closeEntry();
            zis.close();
            return txtTraceFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeZippedOutput(File goalFile, String result) throws IOException, FileNotFoundException {
        try (FileWriter fw = new FileWriter(goalFile);
             ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(goalFile));
             WritableByteChannel channel = Channels.newChannel(zipStream);){
            ZipEntry entry = new ZipEntry("trace.txt");
            zipStream.putNextEntry(entry);
            ByteBuffer bytebuffer = StandardCharsets.UTF_8.encode(result);
            channel.write(bytebuffer);
        }
    }

    public static List<String> getText(File file) throws IOException {
        if (file.getName().endsWith(".txt")) {
            List<String> filetext = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8).stream().map(line -> line.trim()).collect(Collectors.toList());
            return filetext;
        }
        if (file.getName().endsWith(".zip")) {
            try (FileInputStream input = new FileInputStream(file);){
                ZipInputStream zip = new ZipInputStream(input);
                ZipEntry entry = zip.getNextEntry();
                ArrayList<String> lines = new ArrayList<String>();
                Scanner sc = new Scanner(zip);
                while (sc.hasNextLine()) {
                    lines.add(sc.nextLine());
                }
                ArrayList<String> arrayList = lines;
                return arrayList;
            }
        }
        List<String> filetext = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8).stream().map(line -> line.trim()).collect(Collectors.toList());
        return filetext;
    }
}

