/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependencyprocessors;

import de.dagere.peass.dependency.persistence.SelectedTests;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class CommitComparatorInstance
implements Comparator<String> {
    public static final String NO_BEFORE = "NO_BEFORE";
    private final List<String> commits;

    public CommitComparatorInstance(List<String> commits) {
        this.commits = commits;
    }

    public CommitComparatorInstance(SelectedTests dependencies2) {
        this.commits = new LinkedList<String>();
        Arrays.stream(dependencies2.getCommitNames()).forEach(commit -> this.commits.add((String)commit));
    }

    @Override
    public int compare(String commit1, String commit2) {
        int indexOf = this.commits.indexOf(commit1);
        int indexOf2 = this.commits.indexOf(commit2);
        return indexOf - indexOf2;
    }

    public boolean isBefore(String commit1, String commit2) {
        int indexOf2;
        int indexOf = this.commits.indexOf(commit1);
        return indexOf < (indexOf2 = this.commits.indexOf(commit2));
    }

    public List<String> getCommits() {
        return this.commits;
    }

    public int getVersionIndex(String commit) {
        return this.commits.indexOf(commit);
    }

    public String getPreviousVersion(String commit) {
        int index = this.commits.indexOf(commit);
        return index > 0 ? this.commits.get(index - 1) : NO_BEFORE;
    }
}

