/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependencyprocessors;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.peass.config.parameters.ExecutionConfigMixin;
import de.dagere.peass.config.parameters.FixedCommitMixin;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.dependency.persistence.InitialCommit;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.dependencyprocessors.VersionComparator;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.utils.Constants;
import de.dagere.peass.vcs.GitUtils;
import de.dagere.peass.vcs.VersionControlSystem;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

public abstract class CommitProcessor
implements Callable<Void> {
    private static final Logger LOG = LogManager.getLogger(CommitProcessor.class);
    @CommandLine.Mixin
    protected ExecutionConfigMixin executionMixin;
    @CommandLine.Mixin
    protected FixedCommitMixin fixedCommitMixin;
    @CommandLine.Option(names={"-folder", "--folder"}, description={"Folder of the project that should be analyzed"}, required=true)
    protected File projectFolder;
    protected PeassFolders folders;
    protected VersionControlSystem vcs;
    protected StaticTestSelection staticTestSelection;
    protected ExecutionData executionData;
    protected String startcommit;
    protected String endcommit;
    protected String commit;
    @CommandLine.Option(names={"-threads", "--threads"}, description={"Number of parallel threads for analysis"})
    protected int threads = 1;
    @CommandLine.Option(names={"-staticSelectionFile", "--staticSelectionFile"}, description={"Path to the staticSelectionFile"})
    protected File staticSelectionFile;
    @CommandLine.Option(names={"-executionFile", "--executionFile"}, description={"Path to the executionfile (may be trace based selection or coverage selection file)"})
    protected File executionFile;

    public CommitProcessor(File projectFolder, StaticTestSelection dependencies) {
        this.folders = new PeassFolders(projectFolder);
        this.staticTestSelection = dependencies;
        this.startcommit = null;
        this.endcommit = null;
        this.threads = 1;
    }

    public void setStartversion(String startversion) {
        this.startcommit = startversion;
    }

    public void setEndversion(String endversion) {
        this.endcommit = endversion;
    }

    public CommitProcessor() {
        if (this.executionMixin != null) {
            this.startcommit = this.executionMixin.getStartcommit();
            this.endcommit = this.executionMixin.getEndcommit();
            this.commit = this.fixedCommitMixin.getCommit();
        }
    }

    public void processCommandline() {
        LOG.debug("Processing initial");
        this.processInitialCommit(this.staticTestSelection.getInitialcommit());
        if (this.threads != 1) {
            throw new RuntimeException("Parallel processing is not possible or implemented; do not set threads!");
        }
        for (Map.Entry<String, CommitStaticSelection> version : this.staticTestSelection.getCommits().entrySet()) {
            LOG.debug("Processing {}", (Object)version.getKey());
            this.processCommit(version.getKey(), version.getValue());
        }
        this.postEvaluate();
    }

    protected void processInitialCommit(InitialCommit version) {
    }

    protected abstract void processCommit(String var1, CommitStaticSelection var2);

    protected void postEvaluate() {
    }

    @Override
    public Void call() throws Exception {
        this.initCommitProcessor();
        return null;
    }

    protected void initCommitProcessor() throws IOException, JsonParseException, JsonMappingException {
        if (this.executionMixin != null) {
            this.startcommit = this.executionMixin.getStartcommit();
            this.endcommit = this.executionMixin.getEndcommit();
            this.commit = this.fixedCommitMixin.getCommit();
        }
        if (this.staticSelectionFile != null) {
            this.staticTestSelection = (StaticTestSelection)Constants.OBJECTMAPPER.readValue(this.staticSelectionFile, StaticTestSelection.class);
            VersionComparator.setDependencies(this.staticTestSelection);
            this.executionData = new ExecutionData(this.staticTestSelection);
        }
        if (this.executionFile != null) {
            this.executionData = (ExecutionData)Constants.OBJECTMAPPER.readValue(this.executionFile, ExecutionData.class);
            this.staticTestSelection = new StaticTestSelection(this.executionData);
        }
        if (this.executionData == null && this.staticTestSelection == null) {
            throw new RuntimeException("Static test selection file and executionfile not readable - one needs to be defined!");
        }
        if (!this.projectFolder.exists()) {
            GitUtils.downloadProject(this.staticTestSelection.getUrl(), this.projectFolder);
        }
        this.folders = new PeassFolders(this.projectFolder);
        if (this.startcommit != null || this.endcommit != null) {
            LOG.info("Commit: {} - {}", (Object)this.startcommit, (Object)this.endcommit);
        }
        if (this.fixedCommitMixin.getCommitOld() != null && this.startcommit == null) {
            throw new RuntimeException("If commitOld is specified, always specify commit!");
        }
        if (this.commit != null) {
            if (this.startcommit != null || this.endcommit != null) {
                throw new RuntimeException("Both, commit and (startcommit or endcommit), are defined - define either commit or startcommit/endcommit!");
            }
            this.startcommit = this.commit;
            this.endcommit = this.commit;
            LOG.info("Commit: {} - {}", (Object)this.startcommit, (Object)this.endcommit);
        }
        VersionComparator.setDependencies(this.staticTestSelection);
        this.vcs = VersionControlSystem.getVersionControlSystem(this.folders.getProjectFolder());
    }
}

