/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependencyprocessors;

import de.dagere.peass.dependency.persistence.StaticTestSelection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VersionComparator
implements Comparator<String> {
    public static final String NO_BEFORE = "NO_BEFORE";
    private static final Logger LOG = LogManager.getLogger(VersionComparator.class);
    public static final VersionComparator INSTANCE = new VersionComparator();
    private static List<String> versions;

    @Override
    public int compare(String version1, String version2) {
        int indexOf = versions.indexOf(version1);
        int indexOf2 = versions.indexOf(version2);
        return indexOf - indexOf2;
    }

    public static void setDependencies(StaticTestSelection dependencies2) {
        versions = new LinkedList<String>();
        versions.add(dependencies2.getInitialcommit().getCommit());
        dependencies2.getCommits().keySet().stream().forEach(version -> versions.add((String)version));
    }

    public static void setVersions(List<String> commits) {
        versions = new LinkedList<String>();
        commits.forEach(version -> versions.add((String)version));
    }

    public static boolean hasVersions() {
        return versions != null;
    }

    public Map<String, String> sort(Map<String, String> commits) {
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(commits.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> a, Map.Entry<String, String> b) {
                return VersionComparator.this.compare(a.getKey(), b.getKey());
            }
        });
        LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : entries) {
            sortedMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return sortedMap;
    }
}

