/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.gradle;

import de.dagere.peass.utils.StreamGobbler;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnboxDirHandler {
    private static final Logger LOG = LogManager.getLogger(AnboxDirHandler.class);
    private final String adbCall;

    public AnboxDirHandler(String adb) {
        this.adbCall = adb;
    }

    public void removeDirInEmulator(String path) {
        String shellCommand = String.format("rm -fr %s", path);
        ProcessBuilder builder = new ProcessBuilder(this.adbCall, "shell", shellCommand);
        LOG.debug("ADB: Removing directory {}", (Object)path);
        try {
            Process process = builder.start();
            StreamGobbler.showFullProcess(process);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void createDirInEmulator(String path) {
        String shellCommand = String.format("mkdir -p %s", path);
        ProcessBuilder builder = new ProcessBuilder(this.adbCall, "shell", shellCommand);
        LOG.debug("ADB: Creating directory {}", (Object)path);
        try {
            Process process = builder.start();
            StreamGobbler.showFullProcess(process);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

