/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.gradle;

import com.fasterxml.jackson.databind.node.ObjectNode;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.execution.gradle.AnboxDirHandler;
import de.dagere.peass.execution.gradle.GradleTestExecutor;
import de.dagere.peass.execution.gradle.ManifestEditor;
import de.dagere.peass.execution.processutils.ProcessBuilderHelper;
import de.dagere.peass.execution.utils.CommandConcatenator;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.testtransformation.JUnitTestTransformer;
import de.dagere.peass.utils.Constants;
import de.dagere.peass.utils.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnboxTestExecutor
extends GradleTestExecutor {
    public static final String ANBOX_EMULATOR_FOLDER_BASE = "/storage/emulated/0/Documents/peass/";
    public static final String ANBOX_EMULATOR_FOLDER_TEMP_RESULT = "/storage/emulated/0/Documents/peass/measurementsTemp/";
    public static final String ANDROID_RESOURCES_FOLDER = "app/src/main/resources/";
    public static final String ANDROID_KOPEME_CONFIGURATION = "kopeme_config.json";
    private static final Logger LOG = LogManager.getLogger(AnboxTestExecutor.class);
    private final String adbCall = EnvironmentVariables.fetchAdbCall();
    private final AnboxDirHandler dirHandler = new AnboxDirHandler(this.adbCall);

    public AnboxTestExecutor(PeassFolders folders, JUnitTestTransformer testTransformer, EnvironmentVariables env) {
        super(folders, testTransformer, env);
    }

    @Override
    public void prepareKoPeMeExecution(File logFile) {
        super.prepareKoPeMeExecution(logFile);
        this.writeAndroidConfigJson();
        this.updateAndroidManifest();
        this.adbPush();
        this.compileSources();
    }

    private void writeAndroidConfigJson() {
        ObjectNode androidConfig = Constants.OBJECTMAPPER.createObjectNode();
        androidConfig.put("KOPEME_HOME", ANBOX_EMULATOR_FOLDER_TEMP_RESULT);
        androidConfig.put("kopeme.workingdir", "/storage/emulated/0/Documents/peass/app");
        File kopemeConfig = new File(String.valueOf(this.folders.getProjectFolder()) + "/app/src/main/resources/kopeme_config.json");
        LOG.debug("Creating file: {} with content: {}", (Object)kopemeConfig, (Object)androidConfig.toString());
        try {
            kopemeConfig.getParentFile().mkdirs();
            Constants.OBJECTMAPPER.writerWithDefaultPrettyPrinter().writeValue(kopemeConfig, (Object)androidConfig);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void updateAndroidManifest() {
        File projectFolder = this.folders.getProjectFolder();
        String relativeManifestFilePath = this.testTransformer.getConfig().getExecutionConfig().getAndroidManifest();
        if (relativeManifestFilePath != null) {
            File manifestFile = new File(projectFolder, relativeManifestFilePath);
            try {
                ManifestEditor manifestEditor = new ManifestEditor(manifestFile);
                manifestEditor.updateForExternalStorageReadWrite();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            LOG.error("Android manifest file path is not specified. Use --androidManifest switch to specify the path.");
        }
    }

    private void compileSources() {
        String wrapper = new File(this.folders.getProjectFolder(), EnvironmentVariables.fetchGradleCall()).getAbsolutePath();
        List<String> gradleTasks = this.testTransformer.getConfig().getExecutionConfig().getAndroidGradleTasks();
        Object[] processArgs = this.toMergedArray(wrapper, gradleTasks);
        LOG.debug("Command: {}", (Object)Arrays.toString(processArgs));
        ProcessBuilder builder = new ProcessBuilder((String[])processArgs);
        builder.directory(this.folders.getProjectFolder());
        for (Map.Entry<String, String> entry : this.env.getEnvironmentVariables().entrySet()) {
            LOG.trace("Environment: {} = {}", (Object)entry.getKey(), (Object)entry.getValue());
            builder.environment().put(entry.getKey(), entry.getValue());
        }
        try {
            Process process = builder.start();
            String processOutput = StreamGobbler.getFullProcess(process, true);
            LOG.debug(processOutput);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private String[] toMergedArray(String first, List<String> remaining) {
        String[] mergedArray = new String[1 + (remaining != null ? remaining.size() : 0)];
        mergedArray[0] = first;
        if (remaining != null) {
            int index = 1;
            for (String element : remaining) {
                mergedArray[index++] = element;
            }
        }
        return mergedArray;
    }

    private void adbPush() {
        this.dirHandler.removeDirInEmulator(ANBOX_EMULATOR_FOLDER_BASE);
        this.dirHandler.createDirInEmulator(ANBOX_EMULATOR_FOLDER_BASE);
        String[] filesToBePushed = new String[]{"build.gradle", "gradle.properties", "app/build.gradle"};
        File sourceFolder = this.folders.getProjectFolder();
        for (String fileName : filesToBePushed) {
            File f = new File(fileName);
            this.pushSingleFile(sourceFolder, fileName, f);
        }
    }

    private void pushSingleFile(File sourceFolder, String fileName, File f) {
        if (f.getParent() != null) {
            String subDir = String.format("%s%s", ANBOX_EMULATOR_FOLDER_BASE, f.getParent());
            this.dirHandler.createDirInEmulator(subDir);
        }
        String destinationFolder = ANBOX_EMULATOR_FOLDER_BASE + (String)(f.getParent() != null ? f.getParent() + "/" : "");
        ProcessBuilder builder = new ProcessBuilder(this.adbCall, "push", fileName, destinationFolder);
        builder.directory(sourceFolder);
        LOG.debug("ADB: Pushing {}/{} to {}", (Object)sourceFolder, (Object)fileName, (Object)destinationFolder);
        try {
            Process process = builder.start();
            String processOutput = StreamGobbler.getFullProcess(process, true);
            LOG.debug(processOutput);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void adbPull() {
        ProcessBuilder builder = new ProcessBuilder(this.adbCall, "pull", ANBOX_EMULATOR_FOLDER_TEMP_RESULT, ".");
        builder.directory(this.folders.getPeassFolder());
        LOG.debug("ADB: Pulling {} to {}", (Object)ANBOX_EMULATOR_FOLDER_TEMP_RESULT, (Object)this.folders.getPeassFolder());
        try {
            Process process = builder.start();
            String processOutput = StreamGobbler.getFullProcess(process, true);
            LOG.debug(processOutput);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private Process buildGradleProcess(File moduleFolder, File logFile, TestMethodCall test) {
        String[] anboxOriginals = new String[]{this.adbCall, "shell", "am", "instrument", "-w", "-m", "-e", "class"};
        String testPackageName = this.getTestPackageName(test);
        String[] vars = CommandConcatenator.concatenateCommandArrays(anboxOriginals, new String[]{test.getExecutable(), testPackageName + "/androidx.test.runner.AndroidJUnitRunner"});
        ProcessBuilderHelper processBuilderHelper = new ProcessBuilderHelper(this.env, this.folders);
        processBuilderHelper.parseParams(test.getParams());
        LOG.debug("Executing gradle test in moduleFolder: {}", (Object)moduleFolder);
        return processBuilderHelper.buildFolderProcess(moduleFolder, logFile, vars);
    }

    public String getTestPackageName(TestMethodCall test) {
        Object testPackageName = this.getTestPackageName();
        if (testPackageName != null) {
            return testPackageName;
        }
        testPackageName = test.getPackage().endsWith(".test") ? test.getPackage() : test.getPackage() + ".test";
        return testPackageName;
    }

    public String getTestPackageName() {
        String testPackageName = this.getTestTransformer().getConfig().getExecutionConfig().getAndroidTestPackageName();
        return testPackageName;
    }

    @Override
    protected void runTest(File moduleFolder, File logFile, TestMethodCall test, String testname, long timeout) {
        Process process = this.buildGradleProcess(moduleFolder, logFile, test);
        this.execute(testname, timeout, process);
        this.adbPull();
    }
}

