/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.gradle;

import de.dagere.peass.execution.gradle.GradleParseUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AndroidVersionUtil {
    private static final Logger LOG = LogManager.getLogger(AndroidVersionUtil.class);
    private static Map<Integer, String> versions = new LinkedHashMap<Integer, String>();
    private static Set<String> acceptedVersion = new HashSet<String>();

    public static boolean isLegalBuildTools(String versionString) {
        return !acceptedVersion.contains(versionString) && !versionString.equals("rootProject.buildToolsVersion") && !versionString.equals("rootProject.compileSdkVersion") && !versionString.equals("androidCompileSdkVersion.toInteger") && !versionString.equals("buildConfig.buildTools");
    }

    public static boolean isLegalBuildToolsVersion(String versionString) {
        return !acceptedVersion.contains(versionString) && !versionString.equals("rootProject.buildToolsVersion") && !versionString.equals("rootProject.compileSdkVersion") && !versionString.equals("androidBuildToolsVersion") && !versionString.equals("androidCompileSdkVersion.toInteger()") && !versionString.equals("buildConfig.buildTools");
    }

    private static int getMajorVersion(String versionString) {
        int dotIndex = versionString.indexOf(46);
        if (dotIndex != -1) {
            String part = versionString.substring(0, dotIndex);
            int parsed = Integer.parseInt(part);
            return parsed;
        }
        return Integer.parseInt(versionString);
    }

    public static String getRunningVersion(String versionString) {
        int majorVersion = AndroidVersionUtil.getMajorVersion(versionString);
        return versions.get(majorVersion);
    }

    static {
        ClassLoader classLoader = GradleParseUtil.class.getClassLoader();
        URL versionFile = classLoader.getResource("allowed_android_versions.txt");
        if (versionFile != null) {
            try {
                String[] runningAndroidVersions;
                for (String line : runningAndroidVersions = IOUtils.toString((URL)versionFile, (Charset)Charset.defaultCharset()).split("\n")) {
                    String version = line.substring(line.indexOf(59) + 1);
                    versions.put(AndroidVersionUtil.getMajorVersion(version), version.replace("\r", ""));
                    acceptedVersion.add(version);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            LOG.error("No version file existing!");
        }
        File gradle = new File(System.getenv("user.home"), ".gradle");
        if (!gradle.exists()) {
            gradle.mkdir();
        }
    }
}

