/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.gradle;

import de.dagere.kopeme.parsing.GradleParseHelper;
import de.dagere.peass.execution.gradle.GradleBuildfileEditorAnbox;
import de.dagere.peass.execution.gradle.GradleBuildfileVisitor;
import de.dagere.peass.execution.gradle.GradleParseUtil;
import de.dagere.peass.execution.gradle.GradleTaskAnalyzer;
import de.dagere.peass.execution.gradle.TestTaskParser;
import de.dagere.peass.execution.kieker.ArgLineBuilder;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.ProjectModules;
import de.dagere.peass.execution.utils.RequiredDependency;
import de.dagere.peass.testtransformation.JUnitTestTransformer;
import de.dagere.peass.testtransformation.JUnitVersions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GradleBuildfileEditor {
    private static final Logger LOG = LogManager.getLogger(GradleBuildfileEditor.class);
    private final JUnitTestTransformer testTransformer;
    private final File buildfile;
    private final ProjectModules modules;

    public GradleBuildfileEditor(JUnitTestTransformer testTransformer, File buildfile, ProjectModules modules) {
        this.testTransformer = testTransformer;
        this.buildfile = buildfile;
        this.modules = modules;
    }

    public GradleBuildfileVisitor addDependencies(File tempFolder, EnvironmentVariables env) {
        GradleBuildfileVisitor visitor = null;
        try {
            LOG.debug("Editing buildfile: {}", (Object)this.buildfile.getAbsolutePath());
            visitor = GradleParseUtil.parseBuildfile(this.buildfile, this.testTransformer.getConfig().getExecutionConfig());
            GradleTaskAnalyzer executor = new GradleTaskAnalyzer(this.buildfile.getParentFile(), this.testTransformer.getProjectFolder(), env);
            if (executor.isUseJava()) {
                this.editGradlefileContents(tempFolder, visitor, executor);
            } else {
                LOG.debug("Buildfile itself does not contain Java plugin, checking parent projects");
                boolean isUseJava = this.isParentUseJava(this.buildfile, this.modules);
                if (isUseJava) {
                    this.editGradlefileContents(tempFolder, visitor, executor);
                } else {
                    LOG.info("Parent buildfile did not contain java; not changing buildfile");
                }
            }
            LOG.debug("Writing changed buildfile: {}", (Object)this.buildfile.getAbsolutePath());
            Files.write(this.buildfile.toPath(), visitor.getLines(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return visitor;
    }

    private boolean isParentUseJava(File buildfile, ProjectModules modules) throws IOException, FileNotFoundException {
        List<File> parentProjects = modules.getParents(buildfile.getParentFile());
        boolean isUseJava = false;
        for (File parentProject : parentProjects) {
            File parentBuildfile = GradleParseHelper.findGradleFile((File)parentProject);
            LOG.debug("Reading " + String.valueOf(parentBuildfile));
            GradleBuildfileVisitor parentVisitor = GradleParseUtil.parseBuildfile(parentBuildfile, this.testTransformer.getConfig().getExecutionConfig());
            if (!parentVisitor.isSubprojectJava()) continue;
            isUseJava = true;
        }
        return isUseJava;
    }

    private void editGradlefileContents(File tempFolder, GradleBuildfileVisitor visitor, GradleTaskAnalyzer taskAnalyzer) {
        if (visitor.getBuildTools() != -1) {
            GradleParseUtil.updateBuildTools(visitor);
        }
        if (visitor.getBuildToolsVersion() != -1) {
            GradleParseUtil.updateBuildToolsVersion(visitor);
        }
        if (taskAnalyzer.isUseSpringBoot()) {
            LOG.info("Adding spring boot ext");
            GradleParseUtil.addJUnitVersionSpringBoot(visitor);
        } else {
            LOG.info("Did not find spring boot");
        }
        if (this.testTransformer.getConfig().getExecutionConfig().isUseAnbox()) {
            GradleBuildfileEditorAnbox anboxEditor = new GradleBuildfileEditorAnbox(this.testTransformer, this.buildfile, this.modules);
            anboxEditor.executeAnboxSpecificTransformations(visitor);
        }
        GradleParseUtil.removeExclusions(visitor);
        this.addDependencies(visitor);
        if (visitor.getTestTaskProperties() != null && visitor.getTestTaskProperties().getPropertiesLine() != -1 || visitor.getIntegrationTestTaskProperties() != null && visitor.getIntegrationTestTaskProperties().getPropertiesLine() != -1) {
            GradleParseUtil.updateExecutionMode(visitor);
        }
        this.addKiekerLine(tempFolder, visitor, taskAnalyzer);
    }

    private void addDependencies(GradleBuildfileVisitor visitor) {
        JUnitVersions versions = this.testTransformer.getJUnitVersions();
        boolean isExcludeLog4j = this.testTransformer.getConfig().getExecutionConfig().isExcludeLog4jSlf4jImpl();
        boolean isAnbox = this.testTransformer.getConfig().getExecutionConfig().isUseAnbox();
        if (visitor.getDependencyLine() != -1) {
            for (RequiredDependency dependency : RequiredDependency.getAll(versions)) {
                String dependencyGradle;
                if (isExcludeLog4j && dependency.getMavenDependency().getArtifactId().contains("kopeme")) {
                    String excludeString = "{ exclude group: 'org.apache.logging.log4j', module: 'log4j-slf4j-impl' }";
                    dependencyGradle = "implementation ('" + dependency.getGradleDependency() + "') " + excludeString;
                } else {
                    if (isAnbox && dependency.getGradleDependency().contains("kopeme")) {
                        String[] excludes;
                        for (String line : excludes = new String[]{"    implementation ('" + dependency.getGradleDependency() + "') {", "        exclude group: 'net.kieker-monitoring', module: 'kieker'", "        exclude group: 'org.hamcrest', module: 'hamcrest'", "        exclude group: 'org.aspectj', module: 'aspectjrt'", "        exclude group: 'org.aspectj', module: 'aspectjweaver'", "        exclude group: 'org.apache.logging.log4j', module: 'log4j-core'", "    }"}) {
                            visitor.addLine(visitor.getDependencyLine() - 1, line);
                        }
                        continue;
                    }
                    dependencyGradle = "implementation '" + dependency.getGradleDependency() + "'";
                }
                visitor.addLine(visitor.getDependencyLine() - 1, dependencyGradle);
            }
            if (visitor.getJunitLine() != -1) {
                visitor.getLines().set(visitor.getJunitLine() - 1, "testImplementation(\"org.junit.jupiter:junit-jupiter:5.12.1\")");
                if (visitor.getJunitPlatformLine() == -1) {
                    visitor.addLine(visitor.getJunitLine() - 1, "testRuntimeOnly(\"org.junit.platform:junit-platform-launcher:1.12.1\")");
                }
            }
            if (this.testTransformer.getConfig().getExecutionConfig().isUseAnbox()) {
                visitor.addLine(visitor.getDependencyLine() - 1, "    androidTestImplementation 'androidx.test:rules:1.4.0'");
            }
        } else {
            visitor.getLines().add("dependencies { ");
            for (RequiredDependency dependency : RequiredDependency.getAll(versions)) {
                String dependencyGradle = "implementation '" + dependency.getGradleDependency() + "'";
                visitor.getLines().add(dependencyGradle);
            }
            if (this.testTransformer.getConfig().getExecutionConfig().isUseAnbox()) {
                visitor.getLines().add("   androidTestImplementation 'androidx.test:rules:1.4.0'");
            }
            visitor.getLines().add("}");
        }
        if (this.testTransformer.getConfig().getExecutionConfig().isExcludeLog4jToSlf4j() && visitor.getAllConfigurationsLine() != -1) {
            String excludeString = "exclude group: 'org.apache.logging.log4j', module: 'log4j-to-slf4j'";
            visitor.addLine(visitor.getAllConfigurationsLine() + 1, excludeString);
        }
    }

    public void addKiekerLine(File tempFolder, GradleBuildfileVisitor visitor, GradleTaskAnalyzer taskAnalyzer) {
        ArgLineBuilder argLineBuilder = new ArgLineBuilder(this.testTransformer, this.buildfile.getParentFile());
        this.addArgLine(visitor, argLineBuilder, tempFolder, taskAnalyzer);
    }

    private void addArgLine(GradleBuildfileVisitor visitor, ArgLineBuilder argLineBuilder, File tempFolder, GradleTaskAnalyzer taskAnalyzer) {
        if (visitor.getAndroidLine() != -1) {
            if (visitor.getUnitTestsAll() != -1) {
                visitor.addLine(visitor.getUnitTestsAll() - 1, argLineBuilder.buildSystemPropertiesGradle(tempFolder));
            } else if (visitor.getTestOptionsAndroid() != -1) {
                visitor.addLine(visitor.getTestOptionsAndroid() - 1, "unitTests.all{" + argLineBuilder.buildSystemPropertiesGradle(tempFolder) + "}");
            } else {
                visitor.addLine(visitor.getAndroidLine() - 1, "testOptions{ unitTests.all{" + argLineBuilder.buildSystemPropertiesGradle(tempFolder) + "} }");
            }
        } else {
            this.enhanceTestTask(visitor, argLineBuilder, tempFolder);
        }
        this.enhanceIntegrationTestTask(visitor, argLineBuilder, tempFolder, taskAnalyzer);
    }

    private void enhanceIntegrationTestTask(GradleBuildfileVisitor visitor, ArgLineBuilder argLineBuilder, File tempFolder, GradleTaskAnalyzer taskAnalyzer) {
        if (visitor.getIntegrationTestLine() != -1) {
            if (visitor.getIntegrationTestTaskProperties().getPropertiesLine() == -1) {
                visitor.addLine(visitor.getIntegrationTestLine() - 1, argLineBuilder.buildSystemPropertiesGradle(tempFolder));
            } else {
                for (Map.Entry<String, String> entry : argLineBuilder.getGradleSystemProperties(tempFolder).entrySet()) {
                    String addedText = GradleParseUtil.createTextForAdding(entry.getKey(), entry.getValue(), visitor.getIntegrationTestTaskProperties().isSystemPropertiesBlock());
                    visitor.addLine(visitor.getIntegrationTestTaskProperties().getPropertiesLine(), addedText);
                }
            }
            TestTaskParser integrationTestTaskProperties = visitor.getIntegrationTestTaskProperties();
            this.adaptTask(visitor, argLineBuilder, integrationTestTaskProperties, visitor.getIntegrationTestLine() - 1);
        } else if (taskAnalyzer.isIntegrationTest()) {
            this.addTestPhaseBlock(visitor, argLineBuilder, tempFolder, "integrationTest {");
            if (visitor.getIntegrationTestTaskProperties() != null) {
                TestTaskParser integrationTestTaskProperties = visitor.getIntegrationTestTaskProperties();
                this.adaptTask(visitor, argLineBuilder, integrationTestTaskProperties, visitor.getLines().size() - 2);
            } else {
                this.adaptTask(visitor, argLineBuilder, null, visitor.getLines().size() - 2);
            }
        }
    }

    private void addTestPhaseBlock(GradleBuildfileVisitor visitor, ArgLineBuilder argLineBuilder, File tempFolder, String blockStart) {
        visitor.addLine(visitor.getLines().size(), blockStart);
        visitor.addLine(visitor.getLines().size(), argLineBuilder.buildSystemPropertiesGradle(tempFolder));
        visitor.addLine(visitor.getLines().size(), "}");
    }

    private void adaptTask(GradleBuildfileVisitor visitor, ArgLineBuilder argLineBuilder, TestTaskParser testTaskParser, int testTaskLine) {
        if (argLineBuilder.getJVMArgs() != null) {
            if (testTaskParser != null && testTaskParser.getJvmArgsLine() != -1) {
                String taskWithoutQuotations = testTaskParser.getTestJvmArgsText().substring(1, testTaskParser.getTestJvmArgsText().length() - 1);
                String testJvmArgsText = "'" + taskWithoutQuotations.replace(", ", ",").replace(",", "','") + "'";
                String adaptedText = argLineBuilder.getJVMArgs(testJvmArgsText);
                visitor.getLines().set(testTaskParser.getJvmArgsLine() - 1, adaptedText);
            } else {
                visitor.addLine(testTaskLine, argLineBuilder.getJVMArgs());
            }
        }
        if (testTaskParser != null && testTaskParser.getMaxHeapSizeLine() != -1 && this.testTransformer.getConfig().getExecutionConfig().getXmx() != null) {
            visitor.getLines().set(testTaskParser.getMaxHeapSizeLine() - 1, "    maxHeapSize = \"" + this.testTransformer.getConfig().getExecutionConfig().getXmx() + "\"");
        }
    }

    private void enhanceTestTask(GradleBuildfileVisitor visitor, ArgLineBuilder argLineBuilder, File tempFolder) {
        if (visitor.getTestLine() != -1) {
            if (visitor.getTestTaskProperties().getPropertiesLine() == -1) {
                visitor.addLine(visitor.getTestLine() - 1, argLineBuilder.buildSystemPropertiesGradle(tempFolder));
            } else {
                for (Map.Entry<String, String> entry : argLineBuilder.getGradleSystemProperties(tempFolder).entrySet()) {
                    String addedText = GradleParseUtil.createTextForAdding(entry.getKey(), entry.getValue(), visitor.getTestTaskProperties().isSystemPropertiesBlock());
                    visitor.addLine(visitor.getTestTaskProperties().getPropertiesLine(), addedText);
                }
            }
            TestTaskParser testTaskProperties = visitor.getTestTaskProperties();
            this.adaptTask(visitor, argLineBuilder, testTaskProperties, visitor.getTestLine() - 1);
        } else {
            this.addTestPhaseBlock(visitor, argLineBuilder, tempFolder, "test {");
            if (visitor.getTestTaskProperties() != null) {
                TestTaskParser testTaskProperties = visitor.getTestTaskProperties();
                this.adaptTask(visitor, argLineBuilder, testTaskProperties, visitor.getLines().size() - 2);
            } else {
                this.adaptTask(visitor, argLineBuilder, null, visitor.getLines().size() - 2);
            }
        }
    }
}

