/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.gradle;

import de.dagere.kopeme.parsing.GradleParseHelper;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.execution.gradle.GradleBuildfileVisitor;
import de.dagere.peass.execution.gradle.GradleParseUtil;
import de.dagere.peass.execution.utils.ProjectModules;
import de.dagere.peass.testtransformation.TestTransformer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GradleBuildfileEditorAnbox {
    private static final Logger LOG = LogManager.getLogger(GradleBuildfileEditorAnbox.class);
    private final String COMPILE_SDK_VERSION = "    compileSdkVersion ";
    private final String MIN_SDK_VERSION = "        minSdkVersion ";
    private final String TARGET_SDK_VERSION = "        targetSdkVersion ";
    private final String MULTIDEX_ENABLED = "        multiDexEnabled = true";
    private final TestTransformer testTransformer;
    private final ProjectModules modules;
    private final File buildfile;

    public GradleBuildfileEditorAnbox(TestTransformer testTransformer, File buildfile, ProjectModules modules) {
        this.testTransformer = testTransformer;
        this.buildfile = buildfile;
        this.modules = modules;
    }

    public void executeAnboxSpecificTransformations(GradleBuildfileVisitor visitor) {
        this.updateGradleVersion(visitor);
        this.adaptSdkVersions(visitor);
        if (visitor.getMultiDexEnabled() != -1) {
            int lineIndex = visitor.getMultiDexEnabled() - 1;
            visitor.getLines().set(lineIndex, "        multiDexEnabled = true");
        } else {
            this.addLineWithinDefaultConfig(visitor, "        multiDexEnabled = true");
        }
        this.addAndroidPackagingOptions(visitor);
        this.addJavaVersionCompatibilityOptions(visitor);
    }

    private void updateGradleVersion(GradleBuildfileVisitor visitor) {
        String gradleVersion = this.testTransformer.getConfig().getExecutionConfig().getAndroidGradleVersion();
        if (gradleVersion != null) {
            if (visitor.getGradleVersionLine() != -1) {
                visitor.getLines().set(visitor.getGradleVersionLine() - 1, "classpath 'com.android.tools.build:gradle:" + gradleVersion + "'");
            }
            List<File> parentProjects = this.modules.getParents(this.buildfile.getParentFile());
            for (File parentProject : parentProjects) {
                File parentBuildfile = GradleParseHelper.findGradleFile((File)parentProject);
                try {
                    GradleBuildfileVisitor parentVisitor = GradleParseUtil.parseBuildfile(parentBuildfile, this.testTransformer.getConfig().getExecutionConfig());
                    if (parentVisitor.getGradleVersionLine() == -1) continue;
                    parentVisitor.getLines().set(parentVisitor.getGradleVersionLine() - 1, "classpath 'com.android.tools.build:gradle:" + gradleVersion + "'");
                    Files.write(parentBuildfile.toPath(), parentVisitor.getLines(), StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    LOG.warn("Gradle file cannot be found");
                }
            }
        }
    }

    private void adaptSdkVersions(GradleBuildfileVisitor visitor) {
        int lineIndex;
        String versionText;
        ExecutionConfig executionConfig = this.testTransformer.getConfig().getExecutionConfig();
        if (executionConfig.getAndroidCompileSdkVersion() != null && visitor.getCompileSdkVersion() != -1) {
            versionText = "    compileSdkVersion " + executionConfig.getAndroidCompileSdkVersion();
            lineIndex = visitor.getCompileSdkVersion() - 1;
            visitor.getLines().set(lineIndex, versionText);
        }
        if (executionConfig.getAndroidMinSdkVersion() != null) {
            versionText = "        minSdkVersion " + executionConfig.getAndroidMinSdkVersion();
            if (visitor.getMinSdkVersion() != -1) {
                lineIndex = visitor.getMinSdkVersion() - 1;
                visitor.getLines().set(lineIndex, versionText);
            } else {
                this.addLineWithinDefaultConfig(visitor, versionText);
            }
        }
        if (executionConfig.getAndroidTargetSdkVersion() != null) {
            versionText = "        targetSdkVersion " + executionConfig.getAndroidTargetSdkVersion();
            if (visitor.getTargetSdkVersion() != -1) {
                lineIndex = visitor.getTargetSdkVersion() - 1;
                visitor.getLines().set(lineIndex, versionText);
            } else {
                this.addLineWithinDefaultConfig(visitor, versionText);
            }
        }
    }

    private void addAndroidPackagingOptions(GradleBuildfileVisitor visitor) {
        String[] excludeFiles = new String[]{"'META-INF/DEPENDENCIES'", "'META-INF/LICENSE.md'", "'META-INF/NOTICE.md'", "'META-INF/jing-copying.html'", "'META-INF/LICENSE-notice.md'"};
        if (visitor.getAndroidPackagingOptions() != -1) {
            this.addExcludeFiles(visitor, excludeFiles);
        } else {
            visitor.addLine(visitor.getAndroidLine() - 1, "    android.packagingOptions {");
            this.addExcludeFiles(visitor, excludeFiles);
            int androidPackagingOptionsEnd = visitor.getAndroidLine();
            visitor.addLine(androidPackagingOptionsEnd - 1, "    }");
            visitor.setAndroidPackagingOptions(androidPackagingOptionsEnd);
        }
    }

    private void addExcludeFiles(GradleBuildfileVisitor visitor, String[] excludeFiles) {
        for (String file : excludeFiles) {
            String packagingOption = "        exclude " + file;
            visitor.addLine(visitor.getAndroidLine() - 1, packagingOption);
        }
    }

    private void addJavaVersionCompatibilityOptions(GradleBuildfileVisitor visitor) {
        int lineIndex;
        String SOURCE_COMPATIBILITY = "sourceCompatibility JavaVersion.VERSION_1_8";
        String TARGET_COMPATIBILITY = "targetCompatibility JavaVersion.VERSION_1_8";
        if (visitor.getSourceCompatibilityLine() != -1) {
            lineIndex = visitor.getSourceCompatibilityLine() - 1;
            visitor.getLines().set(lineIndex, "sourceCompatibility JavaVersion.VERSION_1_8");
        } else {
            this.addLineWithinCompileOptions(visitor, "sourceCompatibility JavaVersion.VERSION_1_8");
        }
        if (visitor.getTargetCompatibilityLine() != -1) {
            lineIndex = visitor.getTargetCompatibilityLine() - 1;
            visitor.getLines().set(lineIndex, "targetCompatibility JavaVersion.VERSION_1_8");
        } else {
            this.addLineWithinCompileOptions(visitor, "targetCompatibility JavaVersion.VERSION_1_8");
        }
    }

    private void addLineWithinCompileOptions(GradleBuildfileVisitor visitor, String textForAdding) {
        if (visitor.getCompileOptionsLine() != -1) {
            visitor.addLine(visitor.getCompileOptionsLine() - 1, textForAdding);
        } else {
            visitor.addLine(visitor.getAndroidLine() - 1, "    compileOptions {");
            visitor.addLine(visitor.getAndroidLine() - 1, textForAdding);
            int compileOptionsEnd = visitor.getAndroidLine();
            visitor.addLine(compileOptionsEnd - 1, "    }");
            visitor.setCompileOptionsLine(compileOptionsEnd);
        }
    }

    private void addLineWithinDefaultConfig(GradleBuildfileVisitor visitor, String textForAdding) {
        if (visitor.getDefaultConfigLine() != -1) {
            visitor.addLine(visitor.getDefaultConfigLine() - 1, textForAdding);
        } else {
            visitor.addLine(visitor.getAndroidLine() - 1, "    defaultConfig {");
            visitor.addLine(visitor.getAndroidLine() - 1, textForAdding);
            int defaultConfigEnd = visitor.getAndroidLine();
            visitor.addLine(defaultConfigEnd - 1, "    }");
            visitor.setDefaultConfigLine(defaultConfigEnd);
        }
    }
}

