/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.gradle;

import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.execution.gradle.TestTaskParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class GradleBuildfileVisitor
extends CodeVisitorSupport {
    private static final Logger LOG = LogManager.getLogger(GradleBuildfileVisitor.class);
    private static final String ADDEDBYPEASS = " // Added dynamically by Peass.";
    public static final String JUPITER_EXECUTION_CONFIG = "junit.jupiter.execution.parallel.enabled";
    public static final String JUPITER_EXECUTION_CONFIG_DEFAULT = "junit.jupiter.execution.parallel.mode.default";
    private int offset = 0;
    private int dependencyLine = -1;
    private int testLine = -1;
    private TestTaskParser testTaskProperties = null;
    private TestTaskParser integrationTestTaskProperties = null;
    private int integrationTestLine = -1;
    private int junitLine = -1;
    private int junitPlatformLine = -1;
    private int androidLine = -1;
    private int compileOptionsLine = -1;
    private int sourceCompatibilityLine = -1;
    private int targetCompatibilityLine = -1;
    private int testOptionsAndroid = -1;
    private int unitTestsAll = -1;
    private int buildTools = -1;
    private int buildToolsVersion = -1;
    private int compileSdkVersion = -1;
    private int defaultConfigLine = -1;
    private int minSdkVersion = -1;
    private int targetSdkVersion = -1;
    private int multiDexEnabled = -1;
    private int gradleVersionLine = -1;
    private int androidPackagingOptions = -1;
    private int allConfigurationsLine = -1;
    private MethodCallExpression configurations = null;
    private List<Integer> excludeLines = new LinkedList<Integer>();
    private boolean hasVersion = true;
    private boolean subprojectJava = false;
    private List<String> gradleFileContents;
    private final ExecutionConfig config;

    public GradleBuildfileVisitor(File buildfile, ExecutionConfig config) throws IOException {
        this.config = config;
        this.gradleFileContents = Files.readAllLines(Paths.get(buildfile.toURI()));
        try (Stream<String> lines = Files.lines(buildfile.toPath());){
            AstBuilder builder = new AstBuilder();
            String content = lines.filter(line -> !line.trim().startsWith("import ") || this.offset++ == -1).collect(Collectors.joining("\n"));
            List nodes = builder.buildFromString(content);
            for (ASTNode node : nodes) {
                node.visit((GroovyCodeVisitor)this);
            }
        }
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        LOG.debug("Call: {}", (Object)call.getMethodAsString());
        if (call != null && call.getMethodAsString() != null) {
            if (call.getMethodAsString().equals("dependencies")) {
                this.dependencyLine = call.getLastLineNumber() + this.offset;
                this.parseDependencies(call);
            } else if (!call.getMethodAsString().equals("buildscript")) {
                if (call.getMethodAsString().equals("test")) {
                    this.testLine = call.getLastLineNumber() + this.offset;
                    if (call.getArguments() instanceof ArgumentListExpression) {
                        ArgumentListExpression arguments = (ArgumentListExpression)call.getArguments();
                        this.testTaskProperties = new TestTaskParser(arguments);
                    }
                } else if (call.getMethodAsString().equals("integrationTest")) {
                    this.integrationTestLine = call.getLastLineNumber() + this.offset;
                    if (call.getArguments() instanceof ArgumentListExpression) {
                        ArgumentListExpression arguments = (ArgumentListExpression)call.getArguments();
                        this.parseTaskDefinition(arguments);
                    }
                } else if (call.getMethodAsString().equals("android")) {
                    this.androidLine = call.getLastLineNumber() + this.offset;
                } else if (call.getMethodAsString().equals("compileOptions")) {
                    this.compileOptionsLine = call.getLastLineNumber() + this.offset;
                } else if (call.getMethodAsString().equals("sourceCompatibility")) {
                    this.sourceCompatibilityLine = call.getLastLineNumber() + this.offset;
                } else if (call.getMethodAsString().equals("targetCompatibility")) {
                    this.targetCompatibilityLine = call.getLastLineNumber() + this.offset;
                } else if (call.getMethodAsString().equals("testOptions")) {
                    this.testOptionsAndroid = call.getLastLineNumber() + this.offset;
                } else if (call.getMethodAsString().equals("unitTests.all")) {
                    this.unitTestsAll = call.getLastLineNumber() + this.offset;
                } else if (call.getMethodAsString().equals("classpath")) {
                    if (this.isGradleVersionLine(call)) {
                        this.gradleVersionLine = call.getLastLineNumber() + this.offset;
                    }
                } else if (call.getMethodAsString().equals("buildToolsVersion")) {
                    this.buildToolsVersion = call.getLastLineNumber() + this.offset;
                } else if (call.getMethodAsString().equals("compileSdkVersion")) {
                    this.compileSdkVersion = call.getLastLineNumber() + this.offset;
                } else if (call.getMethodAsString().equals("defaultConfig")) {
                    this.defaultConfigLine = call.getLastLineNumber() + this.offset;
                } else if (call.getMethodAsString().equals("minSdkVersion")) {
                    this.minSdkVersion = call.getLastLineNumber() + this.offset;
                } else if (call.getMethodAsString().equals("targetSdkVersion")) {
                    this.targetSdkVersion = call.getLastLineNumber() + this.offset;
                } else if (call.getMethodAsString().equals("multiDexEnabled")) {
                    this.multiDexEnabled = call.getLastLineNumber() + this.offset;
                } else if (call.getMethodAsString().equals("android.packagingOptions")) {
                    this.androidPackagingOptions = call.getLastLineNumber() + this.offset;
                } else if (call.getMethodAsString().equals("task")) {
                    this.parseNewTask(call);
                } else if (call.getMethodAsString().equals("register")) {
                    this.parseNewTask(call);
                } else if (call.getMethodAsString().equals("exclude")) {
                    this.parseExcludes(call);
                } else if (call.getMethodAsString().equals("configurations")) {
                    this.configurations = call;
                } else if (call.getMethodAsString().equals("all") && this.configurations != null && call.getLineNumber() >= this.configurations.getLineNumber() && call.getLineNumber() <= this.configurations.getLastLineNumber()) {
                    this.allConfigurationsLine = call.getLineNumber();
                }
            }
        }
        super.visitMethodCallExpression(call);
    }

    private boolean isGradleVersionLine(MethodCallExpression call) {
        Expression expression = call.getArguments();
        if (expression instanceof ArgumentListExpression) {
            ArgumentListExpression argumentList = (ArgumentListExpression)expression;
            boolean isGradleVersionNode = false;
            for (Expression e : argumentList.getExpressions()) {
                isGradleVersionNode |= e.getText().startsWith("com.android.tools.build:gradle");
            }
            return isGradleVersionNode;
        }
        return false;
    }

    private void parseDependencies(MethodCallExpression call) {
        ClosureExpression argumentListExpression;
        Statement code;
        TupleExpression tuple = (TupleExpression)call.getArguments();
        Expression expression = tuple.getExpression(0);
        if (expression instanceof ClosureExpression && (code = (argumentListExpression = (ClosureExpression)expression).getCode()) instanceof BlockStatement) {
            BlockStatement block = (BlockStatement)code;
            for (Statement statement : block.getStatements()) {
                ExpressionStatement expressionStatement;
                if (statement instanceof ReturnStatement) {
                    ReturnStatement returnStatement = (ReturnStatement)statement;
                    if (!returnStatement.getText().contains("org.junit.jupiter:junit-jupiter:")) continue;
                    this.junitLine = returnStatement.getLineNumber();
                    continue;
                }
                if (!(statement instanceof ExpressionStatement) || !(expressionStatement = (ExpressionStatement)statement).getText().contains("org.junit.jupiter:junit-jupiter:")) continue;
                this.junitLine = expressionStatement.getLineNumber();
            }
        }
    }

    private void parseExcludes(MethodCallExpression call) {
        TupleExpression tuple = (TupleExpression)call.getArguments();
        Expression expression = tuple.getExpression(0);
        if (expression instanceof NamedArgumentListExpression) {
            NamedArgumentListExpression argumentListExpression = (NamedArgumentListExpression)expression;
            HashMap<String, String> map = new HashMap<String, String>();
            for (MapEntryExpression innerMapEntryExpression : argumentListExpression.getMapEntryExpressions()) {
                String key = innerMapEntryExpression.getKeyExpression().getText();
                String value = innerMapEntryExpression.getValueExpression().getText();
                map.put(key, value);
            }
            if ("junit".equals(map.get("group")) && "junit".equals(map.get("module"))) {
                this.excludeLines.add(call.getLineNumber() + this.offset);
            }
            if ("org.junit.vintage".equals(map.get("group")) && "junit-vintage-engine".equals(map.get("module"))) {
                this.excludeLines.add(call.getLineNumber() + this.offset);
            }
        }
    }

    private void parseNewTask(MethodCallExpression call) {
        if (call.getArguments() instanceof ArgumentListExpression) {
            ConstantExpression expression;
            MethodCallExpression methodCallExpression;
            Expression method;
            ConstantExpression expression2;
            ArgumentListExpression arguments = (ArgumentListExpression)call.getArguments();
            Expression first = arguments.getExpression(0);
            if (first instanceof ConstantExpression && (expression2 = (ConstantExpression)first).getValue().equals("integrationTest")) {
                this.integrationTestLine = call.getLastLineNumber() + this.offset;
                this.parseTaskDefinition(arguments);
            }
            if (first instanceof MethodCallExpression && (method = (methodCallExpression = (MethodCallExpression)first).getMethod()) instanceof ConstantExpression && (expression = (ConstantExpression)method).getValue().equals("integrationTest")) {
                this.integrationTestLine = call.getLastLineNumber() + this.offset;
                this.parseTaskDefinition(arguments);
            }
        }
    }

    private void parseTaskDefinition(ArgumentListExpression arguments) {
        TestTaskParser parser;
        this.integrationTestTaskProperties = parser = new TestTaskParser(arguments);
    }

    public void visitMapEntryExpression(MapEntryExpression expression) {
        String name = expression.getKeyExpression().getText();
        if (name.equals("buildTools")) {
            this.buildTools = expression.getLineNumber();
        }
        super.visitMapEntryExpression(expression);
    }

    public int getDependencyLine() {
        return this.dependencyLine;
    }

    public int getTestLine() {
        return this.testLine;
    }

    public TestTaskParser getTestTaskProperties() {
        return this.testTaskProperties;
    }

    public int getJunitPlatformLine() {
        return this.junitPlatformLine;
    }

    public int getJunitLine() {
        return this.junitLine;
    }

    public int getAndroidLine() {
        return this.androidLine;
    }

    public int getCompileOptionsLine() {
        return this.compileOptionsLine;
    }

    public void setCompileOptionsLine(int compileOptionsLine) {
        this.compileOptionsLine = compileOptionsLine;
    }

    public int getSourceCompatibilityLine() {
        return this.sourceCompatibilityLine;
    }

    public int getTargetCompatibilityLine() {
        return this.targetCompatibilityLine;
    }

    public int getTestOptionsAndroid() {
        return this.testOptionsAndroid;
    }

    public int getUnitTestsAll() {
        return this.unitTestsAll;
    }

    public int getIntegrationTestLine() {
        return this.integrationTestLine;
    }

    public TestTaskParser getIntegrationTestTaskProperties() {
        return this.integrationTestTaskProperties;
    }

    public boolean isHasVersion() {
        return this.hasVersion;
    }

    public boolean isAndroid() {
        return this.getBuildTools() != -1 || this.androidLine != -1 || this.getBuildToolsVersion() != -1;
    }

    public void setHasVersion(boolean hasVersion) {
        this.hasVersion = hasVersion;
    }

    public boolean hasVersion() {
        return this.hasVersion;
    }

    public int getBuildTools() {
        return this.buildTools;
    }

    public int getBuildToolsVersion() {
        return this.buildToolsVersion;
    }

    public int getCompileSdkVersion() {
        return this.compileSdkVersion;
    }

    public int getDefaultConfigLine() {
        return this.defaultConfigLine;
    }

    public void setDefaultConfigLine(int defaultConfigEnd) {
        this.defaultConfigLine = defaultConfigEnd;
    }

    public int getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public int getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    public int getMultiDexEnabled() {
        return this.multiDexEnabled;
    }

    public int getGradleVersionLine() {
        return this.gradleVersionLine;
    }

    public int getAndroidPackagingOptions() {
        return this.androidPackagingOptions;
    }

    public void setAndroidPackagingOptions(int androidPackagingOptionsEnd) {
        this.androidPackagingOptions = androidPackagingOptionsEnd;
    }

    public boolean isSubprojectJava() {
        return this.subprojectJava;
    }

    public List<String> getLines() {
        return this.gradleFileContents;
    }

    public List<Integer> getExcludeLines() {
        return this.excludeLines;
    }

    public int getAllConfigurationsLine() {
        return this.allConfigurationsLine;
    }

    public void addLine(int lineIndex, String textForAdding) {
        this.gradleFileContents.add(lineIndex, textForAdding + ADDEDBYPEASS);
        if (lineIndex < this.dependencyLine && this.dependencyLine != -1) {
            ++this.dependencyLine;
        }
        if (lineIndex < this.testLine && this.testLine != -1) {
            ++this.testLine;
        }
        if (this.testTaskProperties != null) {
            this.testTaskProperties.increaseLines(lineIndex);
        }
        if (lineIndex < this.integrationTestLine && this.integrationTestLine != -1) {
            ++this.integrationTestLine;
        }
        if (this.integrationTestTaskProperties != null) {
            this.integrationTestTaskProperties.increaseLines(lineIndex);
        }
        if (lineIndex < this.androidLine && this.androidLine != -1) {
            ++this.androidLine;
        }
        if (lineIndex < this.compileOptionsLine && this.compileOptionsLine != -1) {
            ++this.compileOptionsLine;
        }
        if (lineIndex < this.sourceCompatibilityLine && this.sourceCompatibilityLine != -1) {
            ++this.sourceCompatibilityLine;
        }
        if (lineIndex < this.targetCompatibilityLine && this.targetCompatibilityLine != -1) {
            ++this.targetCompatibilityLine;
        }
        if (lineIndex < this.testOptionsAndroid && this.testOptionsAndroid != -1) {
            ++this.testOptionsAndroid;
        }
        if (lineIndex < this.unitTestsAll && this.unitTestsAll != -1) {
            ++this.unitTestsAll;
        }
        if (lineIndex < this.buildTools && this.buildTools != -1) {
            ++this.buildTools;
        }
        if (lineIndex < this.buildToolsVersion && this.buildToolsVersion != -1) {
            ++this.buildToolsVersion;
        }
        if (lineIndex < this.compileSdkVersion && this.compileSdkVersion != -1) {
            ++this.compileSdkVersion;
        }
        if (lineIndex < this.defaultConfigLine && this.defaultConfigLine != -1) {
            ++this.defaultConfigLine;
        }
        if (lineIndex < this.minSdkVersion && this.minSdkVersion != -1) {
            ++this.minSdkVersion;
        }
        if (lineIndex < this.targetSdkVersion && this.targetSdkVersion != -1) {
            ++this.targetSdkVersion;
        }
        if (lineIndex < this.multiDexEnabled && this.multiDexEnabled != -1) {
            ++this.multiDexEnabled;
        }
        if (lineIndex < this.androidPackagingOptions && this.androidPackagingOptions != -1) {
            ++this.androidPackagingOptions;
        }
        if (lineIndex < this.allConfigurationsLine && this.allConfigurationsLine != -1) {
            ++this.allConfigurationsLine;
        }
        LinkedList<Integer> newExcludeLines = new LinkedList<Integer>();
        for (Integer excludeLine : this.excludeLines) {
            if (lineIndex >= excludeLine) continue;
            newExcludeLines.add(excludeLine + 1);
        }
        this.excludeLines = newExcludeLines;
    }

    public void clearLine(Integer lineNumber) {
        this.gradleFileContents.set(lineNumber - 1, "");
    }
}

