/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.gradle;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GradleDaemonFileDeleter {
    private static final Logger LOG = LogManager.getLogger(GradleDaemonFileDeleter.class);

    public static void deleteDaemonFile(File regularLogFile) {
        try (BufferedReader reader = new BufferedReader(new FileReader(regularLogFile));){
            String daemonFilename = GradleDaemonFileDeleter.findDaemonFilename(reader);
            GradleDaemonFileDeleter.deleteDaemonFileByName(daemonFilename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void deleteDaemonFile(String processOutput) {
        try (BufferedReader reader = new BufferedReader(new StringReader(processOutput));){
            String daemonFilename = GradleDaemonFileDeleter.findDaemonFilename(reader);
            GradleDaemonFileDeleter.deleteDaemonFileByName(daemonFilename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean isLogfile(String daemonFilename) {
        if (daemonFilename != null) {
            return daemonFilename.endsWith(".out.log");
        }
        LOG.debug("daemonFilename could not be determined (is null)!");
        return false;
    }

    private static String findDaemonFilename(BufferedReader reader) throws IOException {
        String searchString = "The client will now receive all logging from the daemon (pid: ";
        int maxSearchLines = 50;
        String daemonLine = "";
        for (int i = 0; i < 50; ++i) {
            daemonLine = reader.readLine();
            if (daemonLine == null || !daemonLine.contains("The client will now receive all logging from the daemon (pid: ")) continue;
            return daemonLine.substring(daemonLine.lastIndexOf(" ") + 1);
        }
        LOG.debug("pid could not be found in first {} lines!", (Object)50);
        return null;
    }

    private static void deleteDaemonFileByName(String daemonFilename) {
        if (GradleDaemonFileDeleter.isLogfile(daemonFilename)) {
            File daemonFile = new File(daemonFilename);
            if (daemonFile.exists()) {
                daemonFile.delete();
            }
        } else {
            LOG.debug("{} does not seem to be a gradle-daemon logfile (does not end with \".out.log\") or is null, so it was not deleted!", (Object)daemonFilename);
        }
    }
}

