/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.gradle;

import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.execution.gradle.AndroidVersionUtil;
import de.dagere.peass.execution.gradle.GradleBuildfileVisitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GradleParseUtil {
    private static final Logger LOG = LogManager.getLogger(GradleParseUtil.class);
    private static final String JUPITER_EXECUTION_CONFIG_CONCURRENT = "junit.jupiter.execution.parallel.mode.default";
    private static final String JUPITER_EXECUTION_CONFIG_CONCURRENT_VALUE = "SAME_THREAD";
    private static final String JUPITER_EXECUTION_CONFIG_MODE = "junit.jupiter.execution.parallel.enabled";
    private static final String JUPITER_EXECUTION_CONFIG_MODE_VALUE = "false";

    public static void writeInitGradle(File init) {
        if (!init.exists()) {
            try (FileWriter fw = new FileWriter(init);){
                PrintWriter pw = new PrintWriter(fw);
                pw.write("allprojects{");
                pw.write(" repositories {");
                pw.write("  mavenLocal();");
                pw.write("  maven { url 'https://maven.google.com' };");
                fw.write(" }");
                fw.write("}");
                pw.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static GradleBuildfileVisitor setAndroidTools(File buildfile, ExecutionConfig config) {
        GradleBuildfileVisitor visitor = null;
        try {
            LOG.debug("Editing: {}", (Object)buildfile);
            visitor = GradleParseUtil.parseBuildfile(buildfile, config);
            List<String> gradleFileContents = Files.readAllLines(Paths.get(buildfile.toURI()));
            if (visitor.getBuildTools() != -1) {
                GradleParseUtil.updateBuildTools(visitor);
            }
            if (visitor.getBuildToolsVersion() != -1) {
                GradleParseUtil.updateBuildToolsVersion(visitor);
            }
            Files.write(buildfile.toPath(), gradleFileContents, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return visitor;
    }

    public static void removeExclusions(GradleBuildfileVisitor visitor) {
        for (Integer lineNumber : visitor.getExcludeLines()) {
            visitor.clearLine(lineNumber);
        }
    }

    public static GradleBuildfileVisitor parseBuildfile(File buildfile, ExecutionConfig config) throws IOException, FileNotFoundException {
        GradleBuildfileVisitor visitor = new GradleBuildfileVisitor(buildfile, config);
        return visitor;
    }

    public static void updateBuildTools(GradleBuildfileVisitor visitor) {
        int lineIndex = visitor.getBuildTools() - 1;
        String versionLine = visitor.getLines().get(lineIndex).trim().replaceAll("'", "").replace("\"", "");
        String versionString = versionLine.split(":")[1].trim();
        if (AndroidVersionUtil.isLegalBuildTools(versionString)) {
            String runningVersion = AndroidVersionUtil.getRunningVersion(versionString);
            if (runningVersion != null) {
                visitor.getLines().set(lineIndex, "'buildTools': '" + runningVersion + "'");
            } else {
                visitor.setHasVersion(false);
            }
        }
    }

    public static void updateBuildToolsVersion(GradleBuildfileVisitor visitor) {
        int lineIndex = visitor.getBuildToolsVersion() - 1;
        String versionLine = visitor.getLines().get(lineIndex).trim().replaceAll("'", "").replace("\"", "");
        String versionString = versionLine.split(" ")[1].trim();
        if (AndroidVersionUtil.isLegalBuildToolsVersion(versionString)) {
            LOG.info(lineIndex + " " + versionLine);
            String runningVersion = AndroidVersionUtil.getRunningVersion(versionString);
            if (runningVersion != null) {
                visitor.getLines().set(lineIndex, "buildToolsVersion " + runningVersion);
            } else {
                visitor.setHasVersion(false);
            }
        }
    }

    public static void addJUnitVersionSpringBoot(GradleBuildfileVisitor visitor) {
        visitor.getLines().add("ext['junit-jupiter.version']='5.12.1'");
    }

    public static void updateExecutionMode(GradleBuildfileVisitor visitor) {
        if (visitor.getTestTaskProperties() != null) {
            for (Map.Entry<String, Integer> entry : visitor.getTestTaskProperties().getExecutionProperties().entrySet()) {
                GradleParseUtil.updateExecutionProperties(visitor, entry, visitor.getTestTaskProperties().isSystemPropertiesBlock());
            }
        }
        if (visitor.getIntegrationTestTaskProperties() != null) {
            for (Map.Entry<String, Integer> entry : visitor.getIntegrationTestTaskProperties().getExecutionProperties().entrySet()) {
                GradleParseUtil.updateExecutionProperties(visitor, entry, visitor.getIntegrationTestTaskProperties().isSystemPropertiesBlock());
            }
        }
    }

    private static void updateExecutionProperties(GradleBuildfileVisitor visitor, Map.Entry<String, Integer> entry, boolean hasSystemPropertiesBlock) {
        int value = entry.getValue();
        if (entry.getKey().equals(JUPITER_EXECUTION_CONFIG_MODE)) {
            visitor.clearLine(value);
            visitor.addLine(value, GradleParseUtil.createTextForAdding(JUPITER_EXECUTION_CONFIG_MODE, JUPITER_EXECUTION_CONFIG_MODE_VALUE, hasSystemPropertiesBlock));
        } else if (entry.getKey().equals(JUPITER_EXECUTION_CONFIG_CONCURRENT)) {
            visitor.clearLine(value);
            visitor.addLine(value, GradleParseUtil.createTextForAdding(JUPITER_EXECUTION_CONFIG_CONCURRENT, JUPITER_EXECUTION_CONFIG_CONCURRENT_VALUE, hasSystemPropertiesBlock));
        }
    }

    public static String createTextForAdding(String key, String value, boolean hasSystemPropertiesBlock) {
        String textProperty = hasSystemPropertiesBlock ? "'" : "  systemProperty   '";
        String separator = hasSystemPropertiesBlock ? "'             : '" : "'             , '";
        String lineSeparator = hasSystemPropertiesBlock ? "'," : "'";
        return textProperty + key + separator + value + lineSeparator;
    }
}

