/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.gradle;

import de.dagere.kopeme.parsing.GradleParseHelper;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.execution.gradle.GradleBuildfileVisitor;
import de.dagere.peass.execution.gradle.GradleDaemonFileDeleter;
import de.dagere.peass.execution.gradle.GradleParseUtil;
import de.dagere.peass.execution.gradle.GradleTestExecutor;
import de.dagere.peass.execution.maven.BuildfileRunningTester;
import de.dagere.peass.execution.processutils.ProcessSuccessTester;
import de.dagere.peass.execution.utils.CommandConcatenator;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.ProjectModules;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.folders.PeassFolders;
import java.io.File;

public class GradleRunningTester
implements BuildfileRunningTester {
    private final PeassFolders folders;
    private final EnvironmentVariables env;
    private final MeasurementConfig measurementConfig;
    private final ProjectModules modules;
    private boolean isAndroid = false;

    public GradleRunningTester(PeassFolders folders, MeasurementConfig measurementConfig, EnvironmentVariables env, ProjectModules modules) {
        this.folders = folders;
        this.measurementConfig = measurementConfig;
        this.env = env;
        this.modules = modules;
    }

    public boolean isCommitRunning(String commit, GradleTestExecutor executor) {
        boolean isRunning = false;
        if (executor.doesBuildfileExist()) {
            String[] vars;
            boolean isAndroid = false;
            for (File module : this.modules.getModules()) {
                File buildfile = GradleParseHelper.findGradleFile((File)module);
                GradleBuildfileVisitor visitor = GradleParseUtil.setAndroidTools(buildfile, this.measurementConfig.getExecutionConfig());
                if (!visitor.isAndroid()) continue;
                isAndroid = true;
                if (visitor.hasVersion()) continue;
                return false;
            }
            this.isAndroid = isAndroid;
            executor.replaceAllBuildfiles(this.modules);
            String cleanGoal = this.measurementConfig.getExecutionConfig().getCleanGoal() != null ? this.measurementConfig.getExecutionConfig().getCleanGoal() : "clean";
            String[] basicVars = new String[]{EnvironmentVariables.fetchGradleCall(), "--no-daemon"};
            if (!isAndroid) {
                if (this.measurementConfig.getExecutionConfig().getExecutableCheckGoals().isEmpty()) {
                    String[] temp = CommandConcatenator.concatenateCommandArrays(basicVars, new String[]{cleanGoal});
                    vars = CommandConcatenator.concatenateCommandArrays(temp, this.measurementConfig.getExecutionConfig().getExecutableCheckGoals().toArray(new String[0]));
                } else {
                    vars = CommandConcatenator.concatenateCommandArrays(basicVars, new String[]{cleanGoal, "testClasses", "assemble"});
                }
            } else {
                vars = CommandConcatenator.concatenateCommandArrays(basicVars, new String[]{"assemble"});
            }
            ProcessSuccessTester processSuccessTester = new ProcessSuccessTester(this.folders, this.measurementConfig, this.env);
            isRunning = processSuccessTester.testRunningSuccess(commit, vars);
            File cleanLogFile = this.folders.getDependencyLogSuccessRunFile(commit);
            GradleDaemonFileDeleter.deleteDaemonFile(cleanLogFile);
        }
        return isRunning;
    }

    public boolean isAndroid() {
        return this.isAndroid;
    }

    @Override
    public boolean isCommitRunning(String commit, TestExecutor executor) {
        if (!(executor instanceof GradleTestExecutor)) {
            throw new RuntimeException("Can only be called with GradleTestExecutor, but was " + String.valueOf(executor.getClass()));
        }
        return this.isCommitRunning(commit, (GradleTestExecutor)executor);
    }
}

