/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.gradle;

import de.dagere.kopeme.parsing.GradleParseHelper;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.execution.gradle.GradleBuildfileEditor;
import de.dagere.peass.execution.gradle.GradleBuildfileVisitor;
import de.dagere.peass.execution.gradle.GradleDaemonFileDeleter;
import de.dagere.peass.execution.gradle.GradleParseUtil;
import de.dagere.peass.execution.gradle.GradleRunningTester;
import de.dagere.peass.execution.gradle.SettingsFileParser;
import de.dagere.peass.execution.processutils.ProcessBuilderHelper;
import de.dagere.peass.execution.utils.CommandConcatenator;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.KoPeMeExecutor;
import de.dagere.peass.execution.utils.ProjectModules;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.testtransformation.JUnitTestTransformer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GradleTestExecutor
extends KoPeMeExecutor {
    private static final Logger LOG = LogManager.getLogger(GradleTestExecutor.class);
    protected final File gradleHome = this.getGradleHome();

    public GradleTestExecutor(PeassFolders folders, JUnitTestTransformer testTransformer, EnvironmentVariables env) {
        super(folders, testTransformer, env);
        env.getEnvironmentVariables().put("GRADLE_HOME", this.gradleHome.getAbsolutePath());
    }

    @Override
    public void prepareKoPeMeExecution(File logFile) {
        LOG.debug("Starting Test Transformation");
        this.prepareKiekerSource();
        this.transformTests();
        this.prepareBuildfile();
    }

    public File getGradleHome() {
        File projectFolder = this.folders.getProjectFolder();
        File peassFolder = new File(projectFolder.getParentFile(), projectFolder.getName() + "_peass");
        File gradleHome = new File(peassFolder, "gradleHome");
        gradleHome.mkdir();
        File init = new File(gradleHome, "init.gradle");
        GradleParseUtil.writeInitGradle(init);
        return gradleHome;
    }

    private void prepareBuildfile() {
        try {
            this.lastTmpFile = Files.createTempDirectory(this.folders.getKiekerTempFolder().toPath(), "kiekerTemp", new FileAttribute[0]).toFile();
            this.isAndroid = false;
            ProjectModules modules = this.getModules();
            LOG.debug("Preparing modules: {}", (Object)modules);
            this.replaceAllBuildfiles(modules);
            for (File module : modules.getModules()) {
                File gradleFile = GradleParseHelper.findGradleFile((File)module);
                this.editOneBuildfile(gradleFile, modules);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void replaceBuildfile(File gradleFile) throws IOException {
        File potentialAlternativeFile = new File(gradleFile.getParentFile(), "alternative_build.gradle");
        if (potentialAlternativeFile.exists()) {
            LOG.debug("Replacing {} by {}", (Object)gradleFile, (Object)potentialAlternativeFile);
            gradleFile.delete();
            FileUtils.moveFile((File)potentialAlternativeFile, (File)gradleFile);
        }
    }

    private void editOneBuildfile(File gradleFile, ProjectModules modules) {
        GradleBuildfileEditor editor = new GradleBuildfileEditor(this.testTransformer, gradleFile, modules);
        GradleBuildfileVisitor visitor = editor.addDependencies(this.lastTmpFile, this.env);
        if (visitor.isAndroid()) {
            this.isAndroid = true;
        }
    }

    protected String getCleanGoal() {
        ExecutionConfig executionConfig = this.testTransformer.getConfig().getExecutionConfig();
        String cleanGoal = executionConfig.getCleanGoal() != null ? executionConfig.getCleanGoal() : "clean";
        return cleanGoal;
    }

    private Process buildGradleProcess(File moduleFolder, File logFile, TestMethodCall test, String ... commandLineAddition) throws IOException {
        String testGoal = this.getTestGoal();
        String wrapper = new File(this.folders.getProjectFolder(), EnvironmentVariables.fetchGradleCall()).getAbsolutePath();
        String[] originals = new String[]{wrapper, "--init-script", new File(this.gradleHome, "init.gradle").getAbsolutePath(), "--no-daemon", this.getCleanGoal(), testGoal};
        LOG.debug("Redirecting to null: {}", (Object)this.testTransformer.getConfig().getExecutionConfig().isRedirectToNull());
        if (!this.testTransformer.getConfig().getExecutionConfig().isRedirectToNull()) {
            originals = CommandConcatenator.concatenateCommandArrays(originals, new String[]{"--info"});
        }
        String[] vars = CommandConcatenator.concatenateCommandArrays(originals, commandLineAddition);
        ProcessBuilderHelper processBuilderHelper = new ProcessBuilderHelper(this.env, this.folders);
        processBuilderHelper.parseParams(test.getParams());
        LOG.debug("Executing gradle test in moduleFolder: {}", (Object)moduleFolder);
        return processBuilderHelper.buildFolderProcess(moduleFolder, logFile, vars);
    }

    public void cleanLastTest(File module) {
        File testFolder = new File(module, "build" + File.separator + "test-results" + File.separator + "release");
        if (testFolder.exists()) {
            LOG.debug("Cleaning: {}", (Object)testFolder);
            try {
                FileUtils.deleteDirectory((File)testFolder);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            LOG.debug("Cleaning not necessary: {}", (Object)testFolder);
        }
    }

    @Override
    public void executeTest(TestMethodCall test, File logFolder, long timeout) {
        File module = new File(this.folders.getProjectFolder(), test.getModule());
        this.cleanLastTest(module);
        this.runMethod(logFolder, test, module, timeout);
        this.cleanAboveSize(logFolder, "txt");
    }

    @Override
    protected void runTest(File moduleFolder, File methodLogFile, TestMethodCall test, String testname, long timeout) {
        try {
            Process process = this.buildGradleProcess(moduleFolder, methodLogFile, test, "--tests", testname);
            this.execute(testname, timeout, process);
            GradleDaemonFileDeleter.deleteDaemonFile(methodLogFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean doesBuildfileExist() {
        File wrapper = new File(this.folders.getProjectFolder(), EnvironmentVariables.fetchGradleCall());
        File potentialBuildfile = new File(this.folders.getProjectFolder(), "build.gradle");
        boolean buildfileExists = wrapper.exists() && potentialBuildfile.exists();
        return buildfileExists;
    }

    @Override
    public boolean isCommitRunning(String commit) {
        ProjectModules modules = this.getModules();
        if (modules != null) {
            GradleRunningTester mavenRunningTester = new GradleRunningTester(this.folders, this.testTransformer.getConfig(), this.env, modules);
            boolean isRunning = mavenRunningTester.isCommitRunning(commit, this);
            this.isAndroid = mavenRunningTester.isAndroid();
            return isRunning;
        }
        return false;
    }

    void replaceAllBuildfiles(ProjectModules modules) {
        if (this.testTransformer.getConfig().getExecutionConfig().isUseAlternativeBuildfile()) {
            for (File module : modules.getModules()) {
                File gradleFile = GradleParseHelper.findGradleFile((File)module);
                try {
                    this.replaceBuildfile(gradleFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public ProjectModules getModules() {
        return SettingsFileParser.getModules(this.folders.getProjectFolder());
    }

    @Override
    public boolean isAndroid() {
        return this.isAndroid;
    }

    @Override
    protected void clean(File logFile) throws IOException, InterruptedException {
    }
}

