/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.gradle;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ManifestEditor {
    private final File file;
    private final Document dom;

    public ManifestEditor(String manifestFilePath) throws ParserConfigurationException, SAXException, IOException {
        this(new File(manifestFilePath));
    }

    public ManifestEditor(File manifestFile) throws ParserConfigurationException, SAXException, IOException {
        this.file = manifestFile;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.dom = builder.parse(manifestFile);
        this.dom.normalizeDocument();
    }

    public void addElement(String element) {
        this.addElement(element, null);
    }

    public void addElement(String elementTag, Map<String, String> attributes) {
        Element root = this.dom.getDocumentElement();
        Element element = this.dom.createElement(elementTag);
        if (attributes != null) {
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                element.setAttribute(attribute.getKey(), attribute.getValue());
            }
        }
        root.appendChild(element);
    }

    public void addAttribute(String elementTag, String attributeKey, String attributeValue) {
        Element root = this.dom.getDocumentElement();
        Node element = root.getElementsByTagName(elementTag).item(0);
        if (element != null && element.getNodeType() == 1) {
            ((Element)element).setAttribute(attributeKey, attributeValue);
        }
    }

    public void writeToFile() throws TransformerException {
        this.writeToFile(this.file);
    }

    public void writeToFile(File file) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(this.dom), new StreamResult(file));
    }

    public void updateForExternalStorageReadWrite() throws TransformerException {
        this.addAttribute("application", "android:requestLegacyExternalStorage", "true");
        this.addElement("uses-permission", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("android:name", "android.permission.READ_EXTERNAL_STORAGE");
            }
        });
        this.addElement("uses-permission", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("android:name", "android.permission.WRITE_EXTERNAL_STORAGE");
            }
        });
        this.writeToFile();
    }
}

