/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.gradle;

import de.dagere.peass.execution.utils.ProjectModules;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SettingsFileParser {
    private static final Logger LOG = LogManager.getLogger(SettingsFileParser.class);
    private String prefix = "";
    private String suffix = "";

    private void readPrefixAndSuffix(File settingsFile) {
        try (BufferedReader reader = new BufferedReader(new FileReader(settingsFile));){
            String line;
            boolean inRootProjectDefinition = false;
            while ((line = reader.readLine()) != null) {
                String fileDefinition;
                String trimmedLined;
                if (line.startsWith("rootProject.children.each {")) {
                    inRootProjectDefinition = true;
                }
                if (inRootProjectDefinition && (trimmedLined = line.trim()).startsWith("subproject.projectDir") && (fileDefinition = trimmedLined.substring(trimmedLined.indexOf("=") + 1).trim()).startsWith("file(")) {
                    String withoutFile = fileDefinition.substring("file(".length()).trim();
                    if (withoutFile.startsWith("\"")) {
                        String withoutLeadingQuotation = withoutFile.substring(1);
                        this.prefix = withoutLeadingQuotation.substring(0, withoutLeadingQuotation.indexOf("\""));
                        withoutFile = withoutLeadingQuotation.substring(withoutLeadingQuotation.indexOf("\"") + 1);
                    }
                    if (withoutFile.contains("\"")) {
                        this.suffix = withoutFile.substring(withoutFile.indexOf("\"") + 1, withoutFile.lastIndexOf("\""));
                    }
                    LOG.info("prefix: " + this.prefix + " Suffix: " + this.suffix);
                }
                if (!line.trim().equals("}") || !inRootProjectDefinition) continue;
                inRootProjectDefinition = false;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ProjectModules getModules(File projectFolder) {
        File settingsFile = new File(projectFolder, "settings.gradle");
        LinkedList<File> modules = new LinkedList<File>();
        if (settingsFile.exists()) {
            SettingsFileParser parser = new SettingsFileParser();
            parser.readPrefixAndSuffix(settingsFile);
            parser.readModules(projectFolder, settingsFile, modules);
        } else {
            LOG.debug("settings-file {} not found", (Object)settingsFile);
        }
        modules.add(projectFolder);
        return new ProjectModules(modules);
    }

    private void readModules(File projectFolder, File settingsFile, List<File> modules) {
        try (BufferedReader reader = new BufferedReader(new FileReader(settingsFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.parseModuleLine(projectFolder, modules, line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void parseModuleLine(File projectFolder, List<File> modules, String line) {
        String[] splitted = line.replaceAll("[ ,]+", " ").split(" ");
        if (splitted[0].equals("include")) {
            for (int candidateIndex = 1; candidateIndex < splitted.length; ++candidateIndex) {
                String candidate = splitted[candidateIndex].substring(1, splitted[candidateIndex].length() - 1);
                String folderName = this.prefix + candidate.replace(":", "") + this.suffix;
                File module = new File(projectFolder, folderName);
                if (module.exists()) {
                    modules.add(module);
                    continue;
                }
                LOG.error(line + " not found! Was looking in " + module.getAbsolutePath());
            }
        }
    }
}

