/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.gradle;

import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class TestTaskParser {
    private int jvmArgsLine = -1;
    private String testJvmArgsText;
    private int propertiesLine = -1;
    private int maxHeapSizeLine = -1;
    private boolean systemPropertiesBlock = false;
    private final Map<String, Integer> executionProperties = new LinkedHashMap<String, Integer>();

    public TestTaskParser(ArgumentListExpression arguments) {
        this.parseTaskWithPotentialSystemProperties(arguments);
    }

    public void parseTaskWithPotentialSystemProperties(ArgumentListExpression arguments) {
        for (Expression argument : arguments.getExpressions()) {
            MethodCallExpression expression;
            if (argument instanceof ClosureExpression) {
                ClosureExpression closure = (ClosureExpression)argument;
                BlockStatement blockStatement = (BlockStatement)closure.getCode();
                for (Statement statement : blockStatement.getStatements()) {
                    ExpressionStatement potentialSystemProperties = null;
                    if (statement instanceof ReturnStatement) {
                        ReturnStatement returnStatement = (ReturnStatement)statement;
                        Expression expression2 = returnStatement.getExpression();
                        String expressionText = expression2.getText();
                        if (expressionText.contains("systemProperties") || expressionText.contains("systemProperty")) {
                            potentialSystemProperties = new ExpressionStatement(expression2);
                        } else if (expressionText.contains("jvmArgs")) {
                            this.parseJvmArgs(expression2);
                        } else if (expressionText.contains("maxHeapSize")) {
                            this.maxHeapSizeLine = expression2.getLineNumber();
                        }
                    } else if (statement instanceof ExpressionStatement) {
                        potentialSystemProperties = (ExpressionStatement)statement;
                        Expression expression3 = potentialSystemProperties.getExpression();
                        if (expression3.getText().contains("jvmArgs")) {
                            this.parseJvmArgs(expression3);
                        } else if (expression3.getText().contains("maxHeapSize")) {
                            this.maxHeapSizeLine = expression3.getLineNumber();
                        }
                    }
                    if (potentialSystemProperties == null || !(potentialSystemProperties.getExpression() instanceof MethodCallExpression)) continue;
                    this.fetchPropertiesLine(potentialSystemProperties);
                }
                continue;
            }
            if (!(argument instanceof MethodCallExpression) || !((expression = (MethodCallExpression)argument).getArguments() instanceof ArgumentListExpression)) continue;
            ArgumentListExpression innerArguments = (ArgumentListExpression)expression.getArguments();
            this.parseTaskWithPotentialSystemProperties(innerArguments);
        }
    }

    private void parseJvmArgs(Expression expression) {
        this.jvmArgsLine = expression.getLineNumber();
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            Expression rightExpression = binaryExpression.getRightExpression();
            this.testJvmArgsText = rightExpression.getText();
        }
    }

    private void fetchPropertiesLine(ExpressionStatement potentialSystemProperties) {
        MethodCallExpression methodCallExpression = (MethodCallExpression)potentialSystemProperties.getExpression();
        String method = methodCallExpression.getMethodAsString();
        ArgumentListExpression propertiesArguments = (ArgumentListExpression)methodCallExpression.getArguments();
        if (method.equals("systemProperties")) {
            MapExpression map = (MapExpression)propertiesArguments.getExpression(0);
            if (this.executionProperties != null) {
                this.systemPropertiesBlock = true;
                for (MapEntryExpression expression : map.getMapEntryExpressions()) {
                    String key = expression.getKeyExpression().getText();
                    String value = expression.getValueExpression().getText();
                    this.propertiesLine = expression.getLineNumber();
                    this.addExecutionProperties(key, value);
                }
            }
        } else if (method.equals("systemProperty") && this.executionProperties != null) {
            this.systemPropertiesBlock = false;
            this.propertiesLine = propertiesArguments.getExpression(0).getLineNumber();
            String key = propertiesArguments.getExpression(0).getText();
            String value = propertiesArguments.getExpression(1).getText();
            this.addExecutionProperties(key, value);
        }
    }

    private void addExecutionProperties(String key, String value) {
        if (key.startsWith("junit.jupiter.execution.parallel.mode.default") && value.contains("concurrent")) {
            this.executionProperties.put("junit.jupiter.execution.parallel.mode.default", this.propertiesLine);
        }
        if (key.startsWith("junit.jupiter.execution.parallel.enabled") && value.contains("true")) {
            this.executionProperties.put("junit.jupiter.execution.parallel.enabled", this.propertiesLine);
        }
    }

    public void increaseLines(int addedLineIndex) {
        if (addedLineIndex < this.jvmArgsLine && this.jvmArgsLine != -1) {
            ++this.jvmArgsLine;
        }
        if (addedLineIndex < this.propertiesLine && this.propertiesLine != -1) {
            ++this.propertiesLine;
            for (Map.Entry<String, Integer> entry : this.executionProperties.entrySet()) {
                entry.setValue(entry.getValue() + 1);
            }
        }
        if (addedLineIndex < this.maxHeapSizeLine && this.maxHeapSizeLine != -1) {
            ++this.maxHeapSizeLine;
        }
    }

    public int getJvmArgsLine() {
        return this.jvmArgsLine;
    }

    public String getTestJvmArgsText() {
        return this.testJvmArgsText;
    }

    public int getPropertiesLine() {
        return this.propertiesLine;
    }

    public int getMaxHeapSizeLine() {
        return this.maxHeapSizeLine;
    }

    public boolean isSystemPropertiesBlock() {
        return this.systemPropertiesBlock;
    }

    public Map<String, Integer> getExecutionProperties() {
        return this.executionProperties;
    }
}

