/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.kieker;

import de.dagere.peass.testtransformation.TestTransformer;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArgLineBuilder {
    private static final Logger LOG = LogManager.getLogger(ArgLineBuilder.class);
    public static final String TEMP_DIR_PURE = "java.io.tmpdir";
    public static final String TEMP_DIR = "-Djava.io.tmpdir";
    private static final String KIEKER_CONFIGURATION_PURE = "kieker.monitoring.configuration";
    private static final String KIEKER_CONFIGURATION = "-Dkieker.monitoring.configuration";
    private static final String MONITORING_PROPERTIES_PATH = "/src/main/resources/META-INF/kieker.monitoring.properties";
    public static final String JAVA_AGENT = "-javaagent";
    public static final String RELATIVE_MAVEN_FOLDER = ".m2" + File.separator + "repository" + File.separator + "net" + File.separator + "kieker-monitoring" + File.separator + "kieker" + File.separator + "2.0.2" + File.separator + "kieker-2.0.2-aspectj.jar";
    public static final String KIEKER_FOLDER_MAVEN = "${user.home}" + File.separator + RELATIVE_MAVEN_FOLDER;
    protected static final String KIEKER_ARG_LINE_MAVEN = "-javaagent:" + KIEKER_FOLDER_MAVEN;
    public static final String KIEKER_FOLDER_GRADLE = "${System.properties['user.home']}" + File.separator + RELATIVE_MAVEN_FOLDER;
    protected static final String KIEKER_ARG_LINE_GRADLE = "-javaagent:" + KIEKER_FOLDER_GRADLE;
    private final TestTransformer testTransformer;
    private final File modulePath;
    private static final Pattern XMX_PATTERN = Pattern.compile("-Xmx[0-9]*[m,g]");

    public ArgLineBuilder(TestTransformer testTransformer, File modulePath) {
        this.testTransformer = testTransformer;
        this.modulePath = modulePath;
    }

    public String buildArglineMaven(File tempFolder) {
        Object argLine = this.buildGenericArgline(tempFolder, "=", " ", KIEKER_ARG_LINE_MAVEN);
        if (this.testTransformer.getConfig().getExecutionConfig().getXmx() != null) {
            argLine = (String)argLine + " -Xmx" + this.testTransformer.getConfig().getExecutionConfig().getXmx();
        }
        if (this.testTransformer.getConfig().getExecutionConfig().isPrintCompilation()) {
            argLine = (String)argLine + " -XX:+PrintCompilation";
        }
        LOG.debug("Created maven argLine: {}", argLine);
        return argLine;
    }

    protected String buildGenericArgline(File tempFolder, String valueSeparator, String entrySeparator, String kiekerLine) {
        Object argline = this.getTieredCompilationArglinePart(entrySeparator);
        if (this.testTransformer.getConfig().getKiekerConfig().isUseKieker()) {
            String tempFolderPath = "'" + tempFolder.getAbsolutePath() + "'";
            argline = this.testTransformer.getConfig().getKiekerConfig().isUseSourceInstrumentation() && !this.testTransformer.getConfig().getKiekerConfig().isOnlyOneCallRecording() ? (String)argline + TEMP_DIR + valueSeparator + tempFolderPath : (String)argline + kiekerLine + entrySeparator + TEMP_DIR + valueSeparator + tempFolderPath;
            argline = !entrySeparator.contains("\"") ? (String)argline + " -Dkieker.monitoring.configuration" + valueSeparator + "\"" + this.modulePath.getAbsolutePath() + "/src/main/resources/META-INF/kieker.monitoring.properties\"" : (String)argline + entrySeparator + KIEKER_CONFIGURATION + valueSeparator + "'" + this.modulePath.getAbsolutePath() + "/src/main/resources/META-INF/kieker.monitoring.properties'";
        }
        return argline;
    }

    private String getTieredCompilationArglinePart(String entrySeparator) {
        Object argline = this.testTransformer.getConfig().getExecutionConfig().isUseTieredCompilation() ? "-XX:-TieredCompilation" + entrySeparator : "";
        return argline;
    }

    public String buildSystemPropertiesGradle(File tempFolder) {
        if (this.testTransformer.getConfig().getKiekerConfig().isUseKieker()) {
            String tempPathNoEscapes = tempFolder.getAbsolutePath().replace('\\', '/');
            String systemProperties = "  systemProperty \"java.io.tmpdir\", \"" + tempPathNoEscapes + "\"" + System.lineSeparator();
            String configFilePath = this.modulePath.getAbsolutePath().replace('\\', '/') + MONITORING_PROPERTIES_PATH;
            systemProperties = systemProperties + "  systemProperty \"kieker.monitoring.configuration\", \"" + configFilePath + "\"" + System.lineSeparator();
            LOG.debug("Created gradle properties: {}", (Object)systemProperties);
            return systemProperties;
        }
        return "";
    }

    public Map<String, String> getGradleSystemProperties(File tempFolder) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        if (this.testTransformer.getConfig().getKiekerConfig().isUseKieker()) {
            String tempPathNoEscapes = tempFolder.getAbsolutePath().replace('\\', '/');
            properties.put(TEMP_DIR_PURE, tempPathNoEscapes);
            String configFilePath = this.modulePath.getAbsolutePath().replace('\\', '/') + MONITORING_PROPERTIES_PATH;
            properties.put(KIEKER_CONFIGURATION_PURE, configFilePath);
        } else {
            String tempPathNoEscapes = tempFolder.getAbsolutePath().replace('\\', '/');
            properties.put(TEMP_DIR_PURE, tempPathNoEscapes);
        }
        return properties;
    }

    public String getJVMArgs() {
        String potentialXmxArgLine = this.getXmxArgLine("");
        if (!this.testTransformer.getConfig().getKiekerConfig().isUseSourceInstrumentation() || this.testTransformer.getConfig().getKiekerConfig().isOnlyOneCallRecording()) {
            return "  jvmArgs=[\"" + KIEKER_ARG_LINE_GRADLE + "\"," + potentialXmxArgLine + "]";
        }
        if (potentialXmxArgLine.length() > 0) {
            return "  jvmArgs=[" + potentialXmxArgLine + "]";
        }
        return null;
    }

    public String getJVMArgs(String oldArgLine) {
        String changedArgLine = this.getXmxArgLine(oldArgLine);
        if (!this.testTransformer.getConfig().getKiekerConfig().isUseSourceInstrumentation() || this.testTransformer.getConfig().getKiekerConfig().isOnlyOneCallRecording()) {
            return "  jvmArgs=[\"" + KIEKER_ARG_LINE_GRADLE + "\"," + changedArgLine + "]";
        }
        return changedArgLine;
    }

    private String getXmxArgLine(String oldArgLine) {
        if (this.testTransformer.getConfig().getExecutionConfig().getXmx() != null) {
            Object changedArgLine;
            Matcher matcher = XMX_PATTERN.matcher(oldArgLine);
            if (matcher.find()) {
                String xmxString = "-Xmx" + this.testTransformer.getConfig().getExecutionConfig().getXmx();
                changedArgLine = matcher.replaceFirst(xmxString);
            } else {
                changedArgLine = "\"-Xmx" + this.testTransformer.getConfig().getExecutionConfig().getXmx() + "\"";
            }
            return changedArgLine;
        }
        return oldArgLine;
    }
}

