/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.kieker;

import de.dagere.peass.config.KiekerConfig;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.execution.kieker.AOPXMLHelper;
import de.dagere.peass.execution.maven.pom.MavenTestExecutor;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.testtransformation.TestTransformer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.kieker.sourceinstrumentation.AllowedKiekerRecord;
import net.kieker.sourceinstrumentation.InstrumentationConfiguration;
import net.kieker.sourceinstrumentation.instrument.InstrumentKiekerSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KiekerEnvironmentPreparer {
    private static final Logger LOG = LogManager.getLogger(KiekerEnvironmentPreparer.class);
    private static final String[] metaInfFolders = new String[]{"src/main/resources/META-INF", "src/java/META-INF", "src/test/resources/META-INF", "src/test/META-INF", "target/test-classes/META-INF"};
    private final Set<String> includedMethodPattern;
    private final List<String> existingClasses;
    private final PeassFolders folders;
    private final TestTransformer testTransformer;
    private List<File> modules;

    public KiekerEnvironmentPreparer(Set<String> includedMethodPattern, List<String> existingClasses, PeassFolders folders, TestTransformer testTransformer, List<File> modules) {
        this.includedMethodPattern = includedMethodPattern;
        this.existingClasses = existingClasses;
        this.folders = folders;
        this.testTransformer = testTransformer;
        this.modules = modules;
    }

    public void prepareKieker() {
        MeasurementConfig config = this.testTransformer.getConfig();
        KiekerConfig kiekerConfig = config.getKiekerConfig();
        try {
            if (kiekerConfig.isUseSourceInstrumentation() && !kiekerConfig.isOnlyOneCallRecording()) {
                this.instrumentSources(config);
            } else {
                if (kiekerConfig.isEnableAdaptiveMonitoring()) {
                    this.prepareAdaptiveExecution();
                }
                if (kiekerConfig.isOnlyOneCallRecording()) {
                    this.generateAOPXML("de.dagere.kopeme.kieker.probe.OneCallAspectFull");
                } else if (AllowedKiekerRecord.DURATION.equals((Object)kiekerConfig.getRecord())) {
                    this.generateAOPXML(AllowedKiekerRecord.DURATION.getFullName());
                } else {
                    this.generateAOPXML(AllowedKiekerRecord.OPERATIONEXECUTION.getFullName());
                }
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.generateKiekerMonitoringProperties();
    }

    private void instrumentSources(MeasurementConfig config) throws IOException {
        LOG.debug("Create default constructor: {}", (Object)config.getKiekerConfig().isCreateDefaultConstructor());
        LinkedHashSet<String> excludedPatterns = config.getKiekerConfig().getExcludeForTracing();
        this.buildJettyExclusion(excludedPatterns);
        InstrumentKiekerSource instrumentKiekerSource = this.buildInstrumenter(config, excludedPatterns);
        this.instrumentModules(config, instrumentKiekerSource);
        if (config.getKiekerConfig().isEnableAdaptiveMonitoring()) {
            this.writeConfig();
        }
    }

    private void instrumentModules(MeasurementConfig config, InstrumentKiekerSource instrumentKiekerSource) throws IOException {
        for (File module : this.modules) {
            List<String> allClazzFolders = config.getExecutionConfig().getAllClazzFolders();
            File[] files = new File[allClazzFolders.size()];
            for (int i = 0; i < allClazzFolders.size(); ++i) {
                files[i] = new File(module, allClazzFolders.get(i));
            }
            instrumentKiekerSource.instrumentProject(files);
        }
    }

    private InstrumentKiekerSource buildInstrumenter(MeasurementConfig config, HashSet<String> excludedPatterns) {
        InstrumentKiekerSource instrumentKiekerSource;
        AllowedKiekerRecord record = config.getKiekerConfig().getRecord();
        boolean createDefaultConstructor = config.getKiekerConfig().isCreateDefaultConstructor();
        boolean adaptiveInstrumentation = config.getKiekerConfig().isAdaptiveInstrumentation();
        int repetitions = config.getRepetitions();
        boolean extractMethod = config.getKiekerConfig().isExtractMethod();
        boolean strictMode = false;
        if (config.getExecutionConfig().isUseAnbox()) {
            strictMode = true;
        }
        if (!config.getKiekerConfig().isUseSelectiveInstrumentation()) {
            InstrumentationConfiguration kiekerConfiguration = new InstrumentationConfiguration(record, false, createDefaultConstructor, adaptiveInstrumentation, this.includedMethodPattern, excludedPatterns, false, repetitions, extractMethod, strictMode);
            instrumentKiekerSource = new InstrumentKiekerSource(kiekerConfiguration);
        } else {
            InstrumentationConfiguration kiekerConfiguration = new InstrumentationConfiguration(record, config.getKiekerConfig().isUseAggregation(), createDefaultConstructor, adaptiveInstrumentation, this.includedMethodPattern, excludedPatterns, true, repetitions, extractMethod, strictMode);
            instrumentKiekerSource = new InstrumentKiekerSource(kiekerConfiguration);
        }
        return instrumentKiekerSource;
    }

    private void buildJettyExclusion(HashSet<String> excludedPatterns) {
        for (String notInstrumenting : new String[]{"org.eclipse.jetty.logging.JettyLevel", "org.eclipse.jetty.logging.JettyLoggerConfiguration", "org.eclipse.jetty.logging.JettyLoggingServiceProvider", "org.eclipse.jetty.logging.JettyLoggerFactory", "org.eclipse.jetty.logging.StdErrAppender", "org.eclipse.jetty.logging.Timestamp", "org.eclipse.jetty.logging.Timestamp$Tick", "org.eclipse.jetty.logging.JettyLogger"}) {
            excludedPatterns.add("new " + notInstrumenting + ".<init>(..)");
            excludedPatterns.add("* " + notInstrumenting + ".*(..)");
            excludedPatterns.add("*[] " + notInstrumenting + ".*(..)");
            excludedPatterns.add("*.* " + notInstrumenting + ".*(..)");
            excludedPatterns.add("*.*.* " + notInstrumenting + ".*(..)");
            excludedPatterns.add("*.*.*.* " + notInstrumenting + ".*(..)");
            excludedPatterns.add("*.*.*.*.* " + notInstrumenting + ".*(..)");
        }
    }

    private void generateKiekerMonitoringProperties() {
        try {
            for (File module : this.modules) {
                for (String potentialReadFolder : metaInfFolders) {
                    File folder = new File(module, potentialReadFolder);
                    folder.mkdirs();
                    File propertiesFile = new File(folder, "kieker.monitoring.properties");
                    AOPXMLHelper.writeKiekerMonitoringProperties(propertiesFile, this.testTransformer, this.folders);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void prepareAdaptiveExecution() throws IOException, InterruptedException {
        if (!MavenTestExecutor.KIEKER_ASPECTJ_JAR.exists()) {
            throw new RuntimeException("Tweaked Kieker " + String.valueOf(MavenTestExecutor.KIEKER_ASPECTJ_JAR) + " needs to exist - git clone https://github.com/DaGeRe/kieker -b 1_13_tweak and install manually!");
        }
        this.writeConfig();
    }

    private void writeConfig() throws IOException {
        File configFolder = new File(this.folders.getProjectFolder(), "config");
        configFolder.mkdir();
        File adaptiveFile = new File(this.folders.getProjectFolder(), MavenTestExecutor.KIEKER_ADAPTIVE_FILENAME);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(adaptiveFile));){
            writer.write("- *\n");
            for (String includedMethod : this.includedMethodPattern) {
                writer.write("+ " + includedMethod + "\n");
            }
            writer.flush();
        }
    }

    private void generateAOPXML(String aspectName) {
        try {
            for (File module : this.modules) {
                for (String potentialReadFolder : metaInfFolders) {
                    File folder = new File(module, potentialReadFolder);
                    folder.mkdirs();
                    File goalFile2 = new File(folder, "aop.xml");
                    Set<String> clazzes = this.getClazzSet();
                    AOPXMLHelper.writeAOPXMLToFile(new LinkedList<String>(clazzes), goalFile2, aspectName);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Set<String> getClazzSet() {
        HashSet<String> clazzes = new HashSet<String>();
        if (this.includedMethodPattern != null) {
            for (String method : this.includedMethodPattern) {
                String methodBeforeParameters = method.substring(0, method.indexOf(40));
                String clazz = methodBeforeParameters.substring(methodBeforeParameters.lastIndexOf(32) + 1, methodBeforeParameters.lastIndexOf(46));
                clazzes.add(clazz);
            }
        } else {
            clazzes.addAll(this.existingClasses);
        }
        return clazzes;
    }
}

