/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.maven;

import de.dagere.peass.dependency.moduleinfo.ModuleInfoEditor;
import de.dagere.peass.execution.maven.OnePomPreparer;
import de.dagere.peass.execution.utils.ProjectModules;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.testtransformation.TestTransformer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class AllModulePomPreparer {
    private static final Logger LOG = LogManager.getLogger(AllModulePomPreparer.class);
    private final TestTransformer testTransformer;
    private final ProjectModules modules;
    private final PeassFolders folders;
    private File lastTmpFile;
    private Charset lastEncoding;

    public AllModulePomPreparer(TestTransformer testTransformer, ProjectModules modules, PeassFolders folders) {
        this.testTransformer = testTransformer;
        this.modules = modules;
        this.folders = folders;
    }

    public void preparePom() {
        try {
            this.lastTmpFile = Files.createTempDirectory(this.folders.getKiekerTempFolder().toPath(), "kiekerTemp", new FileAttribute[0]).toFile();
            OnePomPreparer preparer = new OnePomPreparer(this.testTransformer);
            for (File module : this.modules.getModules()) {
                this.lastEncoding = preparer.editOneBuildfile(true, new File(module, "pom.xml"), this.lastTmpFile);
                File potentialModuleFile = new File(module, "src/main/java/module-info.java");
                LOG.debug("Checking {}", (Object)potentialModuleFile.getAbsolutePath());
                if (!potentialModuleFile.exists()) continue;
                ModuleInfoEditor.addKiekerRequires(potentialModuleFile);
            }
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
        }
    }

    public Charset getLastEncoding() {
        return this.lastEncoding;
    }
}

