/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.maven;

import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.PeassFolders;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MavenCleaner {
    private static final Logger LOG = LogManager.getLogger(MavenCleaner.class);
    private final PeassFolders folders;
    private final EnvironmentVariables env;

    public MavenCleaner(PeassFolders folders, EnvironmentVariables env) {
        this.folders = folders;
        this.env = env;
    }

    public void clean(File logFile) {
        this.checkProjectFolder();
        this.checkLogParent(logFile);
        ProcessBuilder pbClean = this.buildProcess(logFile);
        this.cleanSafely(pbClean);
    }

    private ProcessBuilder buildProcess(File logFile) {
        String mvnCall = this.env.fetchMavenCall(this.folders.getProjectFolder());
        String[] originalsClean = new String[]{mvnCall, "--batch-mode", "clean"};
        ProcessBuilder pbClean = new ProcessBuilder(originalsClean);
        pbClean.directory(this.folders.getProjectFolder());
        if (logFile != null) {
            pbClean.redirectOutput(ProcessBuilder.Redirect.appendTo(logFile));
            pbClean.redirectError(ProcessBuilder.Redirect.appendTo(logFile));
        }
        return pbClean;
    }

    private void checkProjectFolder() {
        if (!this.folders.getProjectFolder().exists()) {
            throw new RuntimeException("Can not execute clean - folder " + this.folders.getProjectFolder().getAbsolutePath() + " does not exist");
        }
        LOG.debug("Folder {} exists {} and is directory {} - cleaning should be possible", (Object)this.folders.getProjectFolder().getAbsolutePath(), (Object)this.folders.getProjectFolder().exists(), (Object)this.folders.getProjectFolder().isDirectory());
    }

    private void checkLogParent(File logFile) {
        File logParentFile = logFile.getParentFile();
        if (!logParentFile.exists() && !logParentFile.mkdirs()) {
            throw new RuntimeException("Could not create log parent directory: " + String.valueOf(logParentFile));
        }
    }

    private void cleanSafely(ProcessBuilder pbClean) {
        boolean finished = false;
        for (int count = 0; !finished && count < 10; ++count) {
            try {
                Process processClean = pbClean.start();
                finished = processClean.waitFor(60L, TimeUnit.MINUTES);
                if (finished) continue;
                LOG.info("Clean process " + String.valueOf(processClean) + " was not finished successfully; trying again to clean");
                processClean.destroyForcibly();
                continue;
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

