/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.maven;

import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.execution.maven.BuildfileRunningTester;
import de.dagere.peass.execution.maven.MavenUpdater;
import de.dagere.peass.execution.maven.pom.MavenPomUtil;
import de.dagere.peass.execution.processutils.ProcessSuccessTester;
import de.dagere.peass.execution.utils.CommandConcatenator;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.ProjectModules;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.folders.PeassFolders;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenRunningTester
implements BuildfileRunningTester {
    private static final Logger LOG = LogManager.getLogger(MavenRunningTester.class);
    private final PeassFolders folders;
    private final EnvironmentVariables env;
    private final MeasurementConfig measurementConfig;
    private final ProjectModules modules;

    public MavenRunningTester(PeassFolders folders, MeasurementConfig measurementConfig, EnvironmentVariables env, ProjectModules modules) {
        this.folders = folders;
        this.measurementConfig = measurementConfig;
        this.env = env;
        this.modules = modules;
    }

    @Override
    public boolean isCommitRunning(String commit, TestExecutor executor) {
        boolean isRunning;
        block7: {
            File potentialPom = new File(this.folders.getProjectFolder(), "pom.xml");
            File testFolder = new File(this.folders.getProjectFolder(), "src/test");
            isRunning = false;
            if (executor.doesBuildfileExist()) {
                try {
                    boolean multimodule = MavenPomUtil.isMultiModuleProject(potentialPom);
                    if (multimodule || testFolder.exists()) {
                        new MavenUpdater(this.folders, this.modules, this.measurementConfig).updateJava();
                        String goal = this.getGoal();
                        MavenPomUtil.cleanType(potentialPom);
                        String mvnCall = this.env.fetchMavenCall(this.folders.getProjectFolder());
                        String[] basicParameters = new String[]{mvnCall, "--batch-mode", "clean", goal, "-DskipTests", "-Dmaven.test.skip.exec"};
                        String[] withMavendefaults = CommandConcatenator.concatenateCommandArrays(basicParameters, CommandConcatenator.mavenCheckDeactivation);
                        if (this.measurementConfig.getExecutionConfig().getPl() != null) {
                            String[] projectListArray = new String[]{"-pl", this.measurementConfig.getExecutionConfig().getPl(), "-am"};
                            String[] withPl = CommandConcatenator.concatenateCommandArrays(withMavendefaults, projectListArray);
                            isRunning = new ProcessSuccessTester(this.folders, this.measurementConfig, this.env).testRunningSuccess(commit, withPl);
                        } else {
                            isRunning = new ProcessSuccessTester(this.folders, this.measurementConfig, this.env).testRunningSuccess(commit, withMavendefaults);
                        }
                        break block7;
                    }
                    LOG.error("Expected src/test to exist");
                    return false;
                }
                catch (IOException | XmlPullParserException e) {
                    e.printStackTrace();
                }
            } else {
                LOG.error("No pom.xml in {}", (Object)commit);
            }
        }
        return isRunning;
    }

    private String getGoal() {
        String goal = "test-compile";
        if (this.folders.getProjectName().equals("jetty.project") || this.folders.getProjectName().equals("openhab-core")) {
            goal = "package";
        }
        return goal;
    }
}

