/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.maven;

import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.execution.maven.pom.PomJavaUpdater;
import de.dagere.peass.execution.maven.pom.SnapshotRemoveUtil;
import de.dagere.peass.execution.utils.ProjectModules;
import de.dagere.peass.folders.PeassFolders;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenUpdater {
    private static final Logger LOG = LogManager.getLogger(MavenUpdater.class);
    private final PeassFolders folders;
    private final ProjectModules modules;
    private final MeasurementConfig measurementConfig;

    public MavenUpdater(PeassFolders folders, ProjectModules modules, MeasurementConfig measurementConfig) {
        this.folders = folders;
        this.modules = modules;
        this.measurementConfig = measurementConfig;
    }

    public void updateJava() throws FileNotFoundException, IOException, XmlPullParserException {
        File pomFile = new File(this.folders.getProjectFolder(), "pom.xml");
        if (this.measurementConfig.getExecutionConfig().isRemoveSnapshots()) {
            SnapshotRemoveUtil.cleanSnapshotDependencies(pomFile);
        }
        PomJavaUpdater.fixCompilerVersion(pomFile, this.measurementConfig.getExecutionConfig().getGoalCompilerVersion());
        for (File module : this.modules.getModules()) {
            File pomFileModule = new File(module, "pom.xml");
            if (this.measurementConfig.getExecutionConfig().isRemoveSnapshots()) {
                SnapshotRemoveUtil.cleanSnapshotDependencies(pomFileModule);
            }
            PomJavaUpdater.fixCompilerVersion(pomFileModule, this.measurementConfig.getExecutionConfig().getGoalCompilerVersion());
        }
    }
}

