/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.maven;

import de.dagere.peass.execution.kieker.ArgLineBuilder;
import de.dagere.peass.execution.maven.pom.MavenPomUtil;
import de.dagere.peass.testtransformation.TestTransformer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedList;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class OnePomPreparer {
    private final TestTransformer testTransformer;

    public OnePomPreparer(TestTransformer testTransformer) {
        this.testTransformer = testTransformer;
    }

    public Charset editOneBuildfile(boolean update, File pomFile, File lastTmpFile) throws FileNotFoundException, IOException, XmlPullParserException {
        Model model;
        try (FileInputStream fileInputStream = new FileInputStream(pomFile);){
            MavenXpp3Reader reader = new MavenXpp3Reader();
            model = reader.read((InputStream)fileInputStream);
        }
        if (model.getBuild() == null) {
            model.setBuild(new Build());
        }
        String argline = new ArgLineBuilder(this.testTransformer, pomFile.getParentFile()).buildArglineMaven(lastTmpFile);
        MavenPomUtil.extendSurefire(argline, model, update);
        if (model.getDependencies() == null) {
            model.setDependencies(new LinkedList());
        }
        MavenPomUtil.extendDependencies(model, this.testTransformer.getJUnitVersions(), this.testTransformer.getConfig().getExecutionConfig().isExcludeLog4jSlf4jImpl());
        try (FileWriter fileWriter = new FileWriter(pomFile);){
            MavenXpp3Writer writer = new MavenXpp3Writer();
            writer.write((Writer)fileWriter, model);
        }
        Charset lastEncoding = MavenPomUtil.getEncoding(model);
        return lastEncoding;
    }
}

