/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.maven.pom;

import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.execution.maven.pom.ModuleReader;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.ProjectModules;
import de.dagere.peass.execution.utils.RequiredDependency;
import de.dagere.peass.testtransformation.JUnitVersions;
import de.dagere.peass.utils.StreamGobbler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenPomUtil {
    public static final String LOG4J_GROUPID = "org.apache.logging.log4j";
    public static final String LOG4J_SLF4J_IMPL_ARTIFACTID = "log4j-slf4j-impl";
    public static final String LOG4J_TO_SLF4J_ARTIFACTID = "log4j-to-slf4j";
    public static final String KOPEME_VERSION = "1.4.4";
    public static final String KIEKER_VERSION = "2.0.2";
    public static final String ORG_APACHE_MAVEN_PLUGINS = "org.apache.maven.plugins";
    public static final String SUREFIRE_ARTIFACTID = "maven-surefire-plugin";
    public static final String COMPILER_ARTIFACTID = "maven-compiler-plugin";
    public static final String COMPILER_PLUGIN_VERSION = "3.14.0";
    public static final String JUPITER_VERSION = "5.12.1";
    public static final String JUPITER_ENGINE_VERSION = "5.12.1";
    public static final String JUPITER_PLATFORM_VERSION = "1.12.1";
    public static final String LOG4J_VERSION = "2.24.3";
    private static final Logger LOG = LogManager.getLogger(MavenPomUtil.class);

    public static void cleanType(File pomFile) {
        block13: {
            try {
                Model model;
                try (FileInputStream inputStream = new FileInputStream(pomFile);){
                    MavenXpp3Reader reader = new MavenXpp3Reader();
                    model = reader.read((InputStream)inputStream);
                }
                if ((!model.getPackaging().equals("pom") || model.getModules() != null) && model.getModules().size() != 0) break block13;
                model.setPackaging("jar");
                try (FileWriter fileWriter = new FileWriter(pomFile);){
                    MavenXpp3Writer writer = new MavenXpp3Writer();
                    writer.write((Writer)fileWriter, model);
                }
            }
            catch (IOException | XmlPullParserException e) {
                e.printStackTrace();
            }
        }
    }

    public static void extendDependencies(Model model, JUnitVersions versions, boolean excludeLog4j) {
        MavenPomUtil.updateJUnit(model);
        List dependencies = model.getDependencies();
        for (RequiredDependency dependency : RequiredDependency.getAll(versions)) {
            if (dependency.getMavenDependency().getArtifactId().contains("slf4j-impl")) {
                MavenPomUtil.addLoggingImplementationDependency(dependencies, dependency);
                continue;
            }
            if (dependency.getMavenDependency().getArtifactId().contains("kopeme")) {
                dependencies.add(0, dependency.getMavenDependency());
                if (!excludeLog4j) continue;
                Exclusion exclusion = new Exclusion();
                exclusion.setArtifactId(LOG4J_SLF4J_IMPL_ARTIFACTID);
                exclusion.setGroupId(LOG4J_GROUPID);
                ((Dependency)dependencies.get(0)).addExclusion(exclusion);
                continue;
            }
            dependencies.add(dependency.getMavenDependency());
        }
    }

    private static void updateJUnit(Model model) {
        boolean needsToInsertLog4jApi = false;
        for (Dependency dependency : model.getDependencies()) {
            MavenPomUtil.updateDependency(dependency);
            if (!dependency.getGroupId().equals("org.slf4j") || !dependency.getArtifactId().equals("slf4j-api")) continue;
            needsToInsertLog4jApi = true;
        }
        if (needsToInsertLog4jApi) {
            Dependency log4jApi = new Dependency();
            log4jApi.setGroupId(LOG4J_GROUPID);
            log4jApi.setArtifactId("log4j-api");
            log4jApi.setVersion(LOG4J_VERSION);
            model.getDependencies().add(log4jApi);
        }
        if (model.getDependencyManagement() != null) {
            for (Dependency dependency : model.getDependencyManagement().getDependencies()) {
                MavenPomUtil.updateDependency(dependency);
            }
        }
    }

    private static void updateDependency(Dependency dependency) {
        if (dependency.getArtifactId().equals("junit") && dependency.getGroupId().equals("junit")) {
            dependency.setVersion("4.13.2");
        }
        if (dependency.getArtifactId().equals("junit-jupiter") && dependency.getGroupId().equals("org.junit.jupiter")) {
            dependency.setVersion("5.12.1");
        }
        if (dependency.getArtifactId().equals("junit-jupiter-params") && dependency.getGroupId().equals("org.junit.jupiter")) {
            dependency.setVersion("5.12.1");
        }
        if (dependency.getArtifactId().equals("junit-jupiter-engine") && dependency.getGroupId().equals("org.junit.jupiter")) {
            dependency.setVersion("5.12.1");
        }
        if (dependency.getArtifactId().equals("log4j-api") && dependency.getGroupId().equals(LOG4J_GROUPID)) {
            dependency.setVersion(LOG4J_VERSION);
        }
    }

    private static void addLoggingImplementationDependency(List<Dependency> dependencies, RequiredDependency dependency) {
        Dependency originalSlf4j = null;
        for (Dependency original : dependencies) {
            if (!original.getArtifactId().contains("slf4j-impl")) continue;
            originalSlf4j = original;
        }
        if (originalSlf4j != null) {
            originalSlf4j.setScope(null);
        } else {
            dependencies.add(dependency.getMavenDependency());
        }
    }

    public static boolean isMultiModuleProject(File pom) throws FileNotFoundException, IOException, XmlPullParserException {
        try (FileInputStream inputStream = new FileInputStream(pom);){
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((InputStream)inputStream);
            boolean bl = model.getModules() != null;
            return bl;
        }
    }

    public static List<String> getDependentModules(File projectFolder, String pl, EnvironmentVariables env) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(env.fetchMavenCall(projectFolder), "-B", "pre-clean", "-pl", pl, "-am");
        pb.directory(projectFolder);
        String output = StreamGobbler.getFullProcess(pb.start(), false);
        LinkedList<String> modules = new LinkedList<String>();
        for (String line : output.split("\n")) {
            if (!line.contains("---------------<")) continue;
            String[] parts = line.split(" ");
            String groupAnArtifactPart = parts[2];
            String artifact = groupAnArtifactPart.split(":")[1];
            modules.add(artifact);
        }
        return modules;
    }

    public static ProjectModules getModules(File pom, ExecutionConfig config) {
        ProjectModules modules = null;
        try {
            modules = new ModuleReader().readModuleFiles(pom);
            if (config.getPl() != null && !"".equals(config.getPl())) {
                List<String> includedModuleNames = MavenPomUtil.getIncludedModuleNames(pom, config);
                Iterator<File> moduleIterator = modules.getModules().iterator();
                while (moduleIterator.hasNext()) {
                    File moduleFile = moduleIterator.next();
                    String fileModuleName = moduleFile.getName();
                    System.out.println("Name: " + fileModuleName + " " + String.valueOf(includedModuleNames));
                    String fileArtifactId = modules.getArtifactIds().get(moduleFile);
                    System.out.println("Artifactid: " + fileArtifactId);
                    if (includedModuleNames.contains(fileModuleName) || includedModuleNames.contains(fileArtifactId)) continue;
                    moduleIterator.remove();
                }
            }
            return modules;
        }
        catch (IOException | XmlPullParserException e) {
            LOG.error("Was not able to read modules; this commit will not be analyzable!");
            e.printStackTrace();
            return null;
        }
    }

    private static List<String> getIncludedModuleNames(File pom, ExecutionConfig config) throws IOException {
        LinkedList<String> includedModuleNames = new LinkedList<String>();
        ProcessBuilder builder = new ProcessBuilder(EnvironmentVariables.fetchMavenCallGeneric(), "--batch-mode", "pre-clean", "-pl", config.getPl(), "-am");
        builder.directory(pom.getParentFile());
        Process process = builder.start();
        String output = StreamGobbler.getFullProcess(process, false);
        for (String line : output.split("\n")) {
            int startIndex = line.indexOf("-<");
            int endIndex = line.indexOf(">-");
            System.out.println(line + " " + startIndex);
            if (line.startsWith("[ERROR]")) {
                throw new RuntimeException("Unexpected line when reading modules: " + line);
            }
            if (startIndex == -1) continue;
            int expectedModuleNameEnd = endIndex - 1;
            int expectedModuleNameStart = startIndex + 3;
            if (expectedModuleNameEnd < expectedModuleNameStart || line.startsWith("[ERROR]")) {
                throw new RuntimeException("Unexpected line when reading modules: " + line);
            }
            String fullModuleName = line.substring(expectedModuleNameStart, expectedModuleNameEnd);
            String moduleName = fullModuleName.split(":")[1];
            includedModuleNames.add(moduleName);
        }
        return includedModuleNames;
    }

    public static Charset getEncoding(Model model) {
        String encoding;
        Charset value = StandardCharsets.UTF_8;
        Properties properties = model.getProperties();
        if (properties != null && (encoding = (String)properties.get("project.build.sourceEncoding")) != null && encoding.equals("ISO-8859-1")) {
            value = StandardCharsets.ISO_8859_1;
        }
        return value;
    }

    public static Plugin findPlugin(Model model, String artifactId, String groupId) {
        Plugin surefire = null;
        if (model.getBuild() == null) {
            model.setBuild(new Build());
        }
        if (model.getBuild().getPlugins() == null) {
            model.getBuild().setPlugins(new LinkedList());
        }
        for (Plugin plugin : model.getBuild().getPlugins()) {
            if (!plugin.getArtifactId().equals(artifactId) || !plugin.getGroupId().equals(groupId)) continue;
            surefire = plugin;
            break;
        }
        if (surefire == null) {
            surefire = new Plugin();
            surefire.setArtifactId(artifactId);
            surefire.setGroupId(groupId);
            model.getBuild().getPlugins().add(surefire);
        }
        return surefire;
    }

    public static void extendSurefire(String additionalArgLine, Model model, boolean updateVersion) {
        Plugin plugin = MavenPomUtil.findPlugin(model, SUREFIRE_ARTIFACTID, ORG_APACHE_MAVEN_PLUGINS);
        if (plugin.getConfiguration() == null) {
            plugin.setConfiguration((Object)new Xpp3Dom("configuration"));
        }
        if (updateVersion) {
            LOG.trace("Surefire {} {}", plugin.getClass(), plugin.getConfiguration().getClass());
            plugin.setVersion("3.5.3");
        }
        Xpp3Dom conf = (Xpp3Dom)plugin.getConfiguration();
        MavenPomUtil.setConfNode(conf, "forkCount", "1");
        MavenPomUtil.setConfNode(conf, "reuseForks", "false");
        MavenPomUtil.setConfNode(conf, "runOrder", "alphabetical");
        Xpp3Dom argLine = conf.getChild("argLine");
        if (argLine != null) {
            String changedArgLine = argLine.getValue().contains("-Xmx") ? argLine.getValue().replaceAll("-Xmx[0-9]{0,3}[mM]", "-Xmx1g") : argLine.getValue();
            changedArgLine = changedArgLine.replaceAll("$\\{argLine\\}", "");
            argLine.setValue(changedArgLine + " " + additionalArgLine);
        } else {
            argLine = new Xpp3Dom("argLine");
            argLine.setValue(additionalArgLine);
            conf.addChild(argLine);
        }
    }

    public static void extendCompiler(Plugin plugin, String boot_class_path) {
        if (boot_class_path == null || !new File(boot_class_path).exists()) {
            throw new RuntimeException("Boot-Classpath " + boot_class_path + " is not defined.");
        }
        if (plugin.getConfiguration() == null) {
            plugin.setConfiguration((Object)new Xpp3Dom("configuration"));
        }
        LOG.debug("Compiler" + String.valueOf(plugin.getClass()) + " " + String.valueOf(plugin.getConfiguration().getClass()));
        plugin.setVersion(COMPILER_PLUGIN_VERSION);
        LOG.info("BOOT_LIBS: {}", (Object)boot_class_path);
        Xpp3Dom conf = (Xpp3Dom)plugin.getConfiguration();
        Xpp3Dom compilerArguments = MavenPomUtil.findChild(conf, "compilerArguments");
        Xpp3Dom bootclasspath = MavenPomUtil.findChild(compilerArguments, "bootclasspath");
        bootclasspath.setValue(boot_class_path + "/resources.jar${path.separator}" + boot_class_path + "/rt.jar${path.separator}" + boot_class_path + "/sunrsasign.jar:" + boot_class_path + "/jsse.jar${path.separator}" + boot_class_path + "/jce.jar${path.separator}" + boot_class_path + "/charsets.jar${path.separator}" + boot_class_path + "/jfr.jar");
    }

    public static void setIncrementalBuild(Plugin plugin, boolean build) {
        if (plugin.getConfiguration() == null) {
            plugin.setConfiguration((Object)new Xpp3Dom("configuration"));
        }
        LOG.debug("Compiler" + String.valueOf(plugin.getClass()) + " " + String.valueOf(plugin.getConfiguration().getClass()));
        plugin.setVersion(COMPILER_PLUGIN_VERSION);
        Xpp3Dom conf = (Xpp3Dom)plugin.getConfiguration();
        Xpp3Dom compilerArguments = MavenPomUtil.findChild(conf, "useIncrementalCompilation");
        compilerArguments.setValue("" + build);
    }

    private static Xpp3Dom findChild(Xpp3Dom conf, String name) {
        Xpp3Dom compilerArguments = conf.getChild(name);
        if (compilerArguments == null) {
            compilerArguments = new Xpp3Dom(name);
            conf.addChild(compilerArguments);
        }
        return compilerArguments;
    }

    public static Xpp3Dom setConfNode(Xpp3Dom conf, String nodeName, String value) {
        Xpp3Dom confProperty = conf.getChild(nodeName);
        if (confProperty != null) {
            confProperty.setValue(value);
        } else if (confProperty == null) {
            confProperty = new Xpp3Dom(nodeName);
            confProperty.setValue(value);
            conf.addChild(confProperty);
        }
        return confProperty;
    }
}

