/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.maven.pom;

import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.execution.kieker.ArgLineBuilder;
import de.dagere.peass.execution.maven.AllModulePomPreparer;
import de.dagere.peass.execution.maven.MavenCleaner;
import de.dagere.peass.execution.maven.MavenRunningTester;
import de.dagere.peass.execution.maven.MavenUpdater;
import de.dagere.peass.execution.maven.pom.MavenPomUtil;
import de.dagere.peass.execution.maven.pom.PomJavaUpdater;
import de.dagere.peass.execution.maven.pom.SnapshotRemoveUtil;
import de.dagere.peass.execution.processutils.ProcessBuilderHelper;
import de.dagere.peass.execution.utils.CommandConcatenator;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.KoPeMeExecutor;
import de.dagere.peass.execution.utils.ProjectModules;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.testtransformation.JUnitTestTransformer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenTestExecutor
extends KoPeMeExecutor {
    private static final Logger LOG = LogManager.getLogger(MavenTestExecutor.class);
    public static final String SUREFIRE_VERSION = "3.5.3";
    public static final String KIEKER_ADAPTIVE_FILENAME = "config" + File.separator + "kieker.adaptiveMonitoring.conf";
    public static final File KIEKER_ASPECTJ_JAR = new File(ArgLineBuilder.KIEKER_FOLDER_MAVEN.replace("${user.home}", System.getProperty("user.home")));
    protected Charset lastEncoding = StandardCharsets.UTF_8;

    public MavenTestExecutor(PeassFolders folders, JUnitTestTransformer testTransformer, EnvironmentVariables env) {
        super(folders, testTransformer, env);
    }

    protected Process buildMavenProcess(File logFile, TestMethodCall test, String ... commandLineAddition) throws IOException, InterruptedException {
        String testGoal = this.getTestGoal();
        String mvnCall = this.env.fetchMavenCall(this.getProjectFolder());
        String[] originals = new String[]{mvnCall, "--batch-mode", testGoal, "-fn", "-Djava.io.tmpdir=" + this.folders.getTempDir().getAbsolutePath()};
        String[] withMavendefaults = CommandConcatenator.concatenateCommandArrays(originals, CommandConcatenator.mavenCheckDeactivation);
        String[] vars = CommandConcatenator.concatenateCommandArrays(withMavendefaults, commandLineAddition);
        ProcessBuilderHelper processBuilderHelper = new ProcessBuilderHelper(this.env, this.folders);
        processBuilderHelper.parseParams(test.getParams());
        String[] withPl = MavenTestExecutor.addMavenPl(this.testTransformer.getConfig().getExecutionConfig(), vars);
        Process process = processBuilderHelper.buildFolderProcess(this.folders.getProjectFolder(), logFile, withPl);
        return process;
    }

    @Override
    protected void clean(File logFile) {
        new MavenCleaner(this.folders, this.env).clean(logFile);
    }

    @Override
    public void prepareKoPeMeExecution(File logFile) {
        this.updateJava();
        this.clean(logFile);
        LOG.debug("Starting Test Transformation");
        this.prepareKiekerSource();
        this.transformTests();
        AllModulePomPreparer pomPreparer = new AllModulePomPreparer(this.testTransformer, this.getModules(), this.folders);
        pomPreparer.preparePom();
        this.lastEncoding = pomPreparer.getLastEncoding();
    }

    private void updateJava() {
        try {
            new MavenUpdater(this.folders, this.getModules(), this.testTransformer.getConfig()).updateJava();
            File pomFile = new File(this.folders.getProjectFolder(), "pom.xml");
            LOG.info("Remove snapshots: " + this.testTransformer.getConfig().getExecutionConfig().isRemoveSnapshots());
            if (this.testTransformer.getConfig().getExecutionConfig().isRemoveSnapshots()) {
                SnapshotRemoveUtil.cleanSnapshotDependencies(pomFile);
            }
            PomJavaUpdater.fixCompilerVersion(pomFile, this.testTransformer.getConfig().getExecutionConfig().getGoalCompilerVersion());
            for (File module : this.getModules().getModules()) {
                File pomFileModule = new File(module, "pom.xml");
                if (this.testTransformer.getConfig().getExecutionConfig().isRemoveSnapshots()) {
                    SnapshotRemoveUtil.cleanSnapshotDependencies(pomFileModule);
                }
                PomJavaUpdater.fixCompilerVersion(pomFileModule, this.testTransformer.getConfig().getExecutionConfig().getGoalCompilerVersion());
            }
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeTest(TestMethodCall test, File logFolder, long timeout) {
        File moduleFolder = new File(this.folders.getProjectFolder(), test.getModule());
        this.runMethod(logFolder, test, moduleFolder, timeout);
        this.cleanAboveSize(logFolder, "txt");
    }

    @Override
    protected void runTest(File module, File logFile, TestMethodCall test, String testname, long timeout) {
        try {
            Process process = this.testTransformer.getConfig().getExecutionConfig().isPrintCompilation() ? this.buildMavenProcess(logFile, test, "-Dtest=" + testname, "-X") : this.buildMavenProcess(logFile, test, "-Dtest=" + testname);
            this.execute(testname, timeout, process);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean doesBuildfileExist() {
        File pomFile = new File(this.folders.getProjectFolder(), "pom.xml");
        boolean buildfileExists = pomFile.exists();
        return buildfileExists;
    }

    @Override
    public boolean isCommitRunning(String commit) {
        ProjectModules modules = this.getModules();
        if (modules != null) {
            MavenRunningTester mavenRunningTester = new MavenRunningTester(this.folders, this.testTransformer.getConfig(), this.env, modules);
            boolean isRunning = mavenRunningTester.isCommitRunning(commit, this);
            return isRunning;
        }
        return false;
    }

    public Charset getEncoding() {
        return this.lastEncoding;
    }

    @Override
    public ProjectModules getModules() {
        File pomFile = new File(this.folders.getProjectFolder(), "pom.xml");
        return MavenPomUtil.getModules(pomFile, this.testTransformer.getConfig().getExecutionConfig());
    }

    public static String[] addMavenPl(ExecutionConfig config, String[] original) {
        if (config.getPl() != null) {
            String[] projectListArray = new String[]{"-pl", config.getPl(), "-am"};
            String[] withPl = CommandConcatenator.concatenateCommandArrays(original, projectListArray);
            return withPl;
        }
        return original;
    }
}

