/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.maven.pom;

import de.dagere.peass.execution.utils.ProjectModules;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ModuleReader {
    private final ProjectModules modules = new ProjectModules(new LinkedList<File>());

    public ProjectModules readModuleFiles(File pom) throws FileNotFoundException, IOException, XmlPullParserException {
        Model model;
        try (FileInputStream inputStream = new FileInputStream(pom);){
            MavenXpp3Reader reader = new MavenXpp3Reader();
            model = reader.read((InputStream)inputStream);
        }
        if (model.getModules() != null && model.getModules().size() > 0) {
            for (String module : model.getModules()) {
                File moduleFolder = new File(pom.getParentFile(), module);
                File modulePom = new File(moduleFolder, "pom.xml");
                this.readModuleFiles(modulePom);
                if (this.modules.getModules().contains(moduleFolder)) continue;
                this.modules.getModules().add(moduleFolder);
            }
        } else {
            this.modules.getModules().add(pom.getParentFile());
            this.modules.getArtifactIds().put(pom.getParentFile(), model.getArtifactId());
        }
        return this.modules;
    }
}

