/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.maven.pom;

import de.dagere.peass.execution.maven.pom.MavenPomUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PomJavaUpdater {
    private static final Logger LOG = LogManager.getLogger(PomJavaUpdater.class);
    private static final int CURRENT_MAVEN_DEFAULT = 5;

    public static void fixCompilerVersion(File pom, String compilerVersion) throws FileNotFoundException, IOException, XmlPullParserException {
        int version = PomJavaUpdater.getCompilerVersion(pom);
        if (version < 8 && compilerVersion != null) {
            Model model;
            try (FileInputStream inputStream = new FileInputStream(pom);){
                MavenXpp3Reader reader = new MavenXpp3Reader();
                model = reader.read((InputStream)inputStream);
                PomJavaUpdater.setCompiler(model, compilerVersion);
            }
            try (FileWriter fileWriter = new FileWriter(pom);){
                MavenXpp3Writer writer = new MavenXpp3Writer();
                writer.write((Writer)fileWriter, model);
            }
        }
    }

    private static int getCompilerVersion(File pom) throws FileNotFoundException, IOException, XmlPullParserException {
        Model model;
        try (FileInputStream inputStream = new FileInputStream(pom);){
            MavenXpp3Reader reader = new MavenXpp3Reader();
            model = reader.read((InputStream)inputStream);
        }
        Plugin compilerPlugin = MavenPomUtil.findPlugin(model, "maven-compiler-plugin", "org.apache.maven.plugins");
        if (compilerPlugin != null) {
            Xpp3Dom conf = (Xpp3Dom)compilerPlugin.getConfiguration();
            if (conf != null) {
                Xpp3Dom confProperty = conf.getChild("source");
                if (confProperty != null) {
                    String value = confProperty.getValue();
                    if (value.contains(".")) {
                        String versionPart = value.substring(value.indexOf(".") + 1);
                        return PomJavaUpdater.parseVersion(versionPart);
                    }
                    return PomJavaUpdater.parseVersion(value);
                }
                return 5;
            }
            return 5;
        }
        return 5;
    }

    private static int parseVersion(String versionPart) {
        if (versionPart.matches("[0-9]*")) {
            return Integer.parseInt(versionPart);
        }
        return 5;
    }

    private static void setCompiler(Model model, String version) {
        Plugin compilerPlugin = MavenPomUtil.findPlugin(model, "maven-compiler-plugin", "org.apache.maven.plugins");
        if (compilerPlugin.getConfiguration() == null) {
            compilerPlugin.setConfiguration((Object)new Xpp3Dom("configuration"));
        }
        LOG.trace("Compiler {} {}", model.getClass(), compilerPlugin.getConfiguration().getClass());
        compilerPlugin.setVersion("3.14.0");
        Xpp3Dom conf = (Xpp3Dom)compilerPlugin.getConfiguration();
        MavenPomUtil.setConfNode(conf, "source", version);
        MavenPomUtil.setConfNode(conf, "target", version);
    }
}

