/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.maven.pom;

import de.dagere.peass.execution.maven.pom.MavenPomUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class SnapshotRemoveUtil {
    public static void cleanSnapshotDependencies(File pomFile) {
        try {
            Model model;
            try (FileInputStream inputStream = new FileInputStream(pomFile);){
                MavenXpp3Reader reader = new MavenXpp3Reader();
                model = reader.read((InputStream)inputStream);
            }
            Build build = model.getBuild();
            if (build == null) {
                build = new Build();
                model.setBuild(build);
            }
            SnapshotRemoveUtil.removeDependencySnapshots(model);
            SnapshotRemoveUtil.removePluginSnapshots(build);
            SnapshotRemoveUtil.removePluginManagementSnapshots(build);
            try (FileWriter fileWriter = new FileWriter(pomFile);){
                MavenXpp3Writer writer = new MavenXpp3Writer();
                writer.write((Writer)fileWriter, model);
            }
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
        }
    }

    private static void removePluginManagementSnapshots(Build build) {
        if (build.getPluginManagement() != null && build.getPluginManagement().getPlugins() != null) {
            for (Plugin plugin : build.getPluginManagement().getPlugins()) {
                SnapshotRemoveUtil.handlePlugin(plugin);
            }
        }
    }

    private static void removePluginSnapshots(Build build) {
        List plugins = build.getPlugins();
        if (plugins != null) {
            for (Plugin plugin : plugins) {
                SnapshotRemoveUtil.handlePlugin(plugin);
            }
        }
    }

    private static void removeDependencySnapshots(Model model) {
        String selfGroupId = model.getGroupId();
        List dependencies = model.getDependencies();
        if (dependencies != null) {
            for (Dependency dep : dependencies) {
                String groupId;
                String artifactId;
                if (dep.getVersion() == null || (artifactId = dep.getArtifactId()).equals("kopeme-junit") || artifactId.equals("kopeme-junit3") || artifactId.equals("kieker-monitoring") || (groupId = dep.getGroupId()) == null || selfGroupId == null || groupId.startsWith(selfGroupId) || selfGroupId.startsWith(groupId) || !dep.getVersion().endsWith("-SNAPSHOT")) continue;
                dep.setVersion(dep.getVersion().replaceAll("-SNAPSHOT", ""));
            }
        }
    }

    private static void handlePlugin(Plugin plugin) {
        if (plugin.getVersion() != null && plugin.getVersion().endsWith("-SNAPSHOT")) {
            plugin.setVersion(plugin.getVersion().replaceAll("-SNAPSHOT", ""));
        }
        if (plugin.getArtifactId().equals("buildnumber-maven-plugin") && plugin.getConfiguration() != null) {
            Xpp3Dom conf = (Xpp3Dom)plugin.getConfiguration();
            MavenPomUtil.setConfNode(conf, "doUpdate", "false");
        }
    }
}

