/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.processutils;

import de.dagere.peass.execution.utils.CommandConcatenator;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.utils.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessBuilderHelper {
    private static final Logger LOG = LogManager.getLogger(ProcessBuilderHelper.class);
    private final EnvironmentVariables env;
    private final PeassFolders folders;
    private int chosenIndex = -1;

    public ProcessBuilderHelper(EnvironmentVariables env, PeassFolders folders) {
        this.env = env;
        this.folders = folders;
    }

    public Process buildFolderProcess(File currentFolder, File logFile, String[] vars) {
        String[] envPropertyArray = this.env.getProperties().length() > 0 ? this.env.getProperties().split(" ") : new String[]{};
        Object[] varsWithProperties = CommandConcatenator.concatenateCommandArrays(vars, envPropertyArray);
        LOG.debug("Command: {}", (Object)Arrays.toString(varsWithProperties));
        ProcessBuilder pb = new ProcessBuilder((String[])varsWithProperties);
        this.overwriteEnvVars(pb);
        if (this.chosenIndex != -1) {
            pb.environment().put("KOPEME_CHOSEN_PARAMETER_INDEX", Integer.toString(this.chosenIndex));
        }
        pb.directory(currentFolder);
        if (logFile != null) {
            pb.redirectOutput(ProcessBuilder.Redirect.appendTo(logFile));
            pb.redirectError(ProcessBuilder.Redirect.appendTo(logFile));
        }
        try {
            Process process = pb.start();
            this.printPIDInfo(logFile);
            return process;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void overwriteEnvVars(ProcessBuilder pb) {
        LOG.debug("KOPEME_HOME={}", (Object)this.folders.getTempMeasurementFolder().getAbsolutePath());
        pb.environment().put("KOPEME_HOME", this.folders.getTempMeasurementFolder().getAbsolutePath());
        String ldLibraryPath = System.getenv().get("LD_LIBRARY_PATH");
        if (ldLibraryPath != null) {
            LOG.debug("LD_LIBRARY_PATH: {}", (Object)ldLibraryPath);
        }
        for (Map.Entry<String, String> env : System.getenv().entrySet()) {
            pb.environment().put(env.getKey(), env.getValue());
        }
        for (Map.Entry<String, String> entry : this.env.getEnvironmentVariables().entrySet()) {
            LOG.trace("Environment: {} = {}", (Object)entry.getKey(), (Object)entry.getValue());
            pb.environment().put(entry.getKey(), entry.getValue());
        }
    }

    private void printPIDInfo(File logFile) throws IOException {
        if (EnvironmentVariables.isLinux()) {
            String usedPidCountString = new File("/proc/self").getCanonicalFile().getName();
            if (usedPidCountString.matches("[0-9]+")) {
                int pid = Integer.parseInt(usedPidCountString);
                LOG.debug("Process started: {} Used PIDs: {} Log to: {}", (Object)pid, (Object)ProcessBuilderHelper.getProcessCount(), (Object)logFile);
            } else {
                LOG.debug("PID count could not be parsed: {} Operating System: {}", (Object)usedPidCountString, (Object)System.getProperty("os.name"));
            }
        }
    }

    public static synchronized int getProcessCount() {
        int count = -1;
        try {
            Process process = new ProcessBuilder("bash", "-c", "ps -e -T | wc -l").start();
            String result = StreamGobbler.getFullProcess(process, false).replaceAll("\n", "").replace("\r", "");
            count = Integer.parseInt(result.trim());
        }
        catch (NumberFormatException e) {
            if (!e.getMessage().equals("For input string: \"bash: line 1: ps: command not found0\"") && !e.getMessage().equals("For input string: \"0bash: line 1: ps: command not found\"")) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return count;
    }

    public static void syncToHdd() {
        if (EnvironmentVariables.isLinux()) {
            LOG.info("Syncing to hdd");
            try {
                Process syncProcess = Runtime.getRuntime().exec("sync");
                StreamGobbler.showFullProcess(syncProcess);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            LOG.info("No call to sync, since not on Linux");
        }
    }

    public void parseParams(String params) {
        if (params != null && params.matches("JUNIT_PARAMETERIZED-[0-9]+")) {
            String indexString = params.substring(params.indexOf("-") + 1);
            this.chosenIndex = Integer.parseInt(indexString);
        }
    }
}

