/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.processutils;

import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.execution.processutils.ProcessBuilderHelper;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.PeassFolders;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessSuccessTester {
    private static final Logger LOG = LogManager.getLogger(ProcessSuccessTester.class);
    private final PeassFolders folders;
    private final MeasurementConfig measurementConfig;
    private final EnvironmentVariables env;

    public ProcessSuccessTester(PeassFolders folders, MeasurementConfig measurementConfig, EnvironmentVariables env) {
        this.folders = folders;
        this.measurementConfig = measurementConfig;
        this.env = env;
    }

    public boolean testRunningSuccess(String commit, String[] vars) {
        boolean isRunning = false;
        try {
            isRunning = this.testRunning(commit, vars);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return isRunning;
    }

    private boolean testRunning(String commit, String[] vars) throws IOException, InterruptedException, FileNotFoundException {
        boolean isRunning;
        int returncode;
        LOG.debug("Executing run success test {}", (Object)this.folders.getProjectFolder());
        File logFile = this.folders.getDependencyLogSuccessRunFile(commit);
        Process process = this.startProcess(vars, logFile);
        if (process.isAlive()) {
            LOG.debug("Destroying process");
            process.destroyForcibly().waitFor();
        }
        if ((returncode = process.exitValue()) != 0) {
            LOG.info("Success test run failed");
            isRunning = false;
            this.printFailureLogToCommandline(logFile);
        } else {
            LOG.info("Test was successfull");
            isRunning = true;
        }
        return isRunning;
    }

    private Process startProcess(String[] vars, File logFile) throws IOException, InterruptedException {
        ProcessBuilderHelper builder = new ProcessBuilderHelper(this.env, this.folders);
        Process process = builder.buildFolderProcess(this.folders.getProjectFolder(), logFile, vars);
        LOG.debug("Waiting for {} seconds", (Object)this.measurementConfig.getTimeoutInSeconds());
        process.waitFor(this.measurementConfig.getTimeoutInSeconds(), TimeUnit.SECONDS);
        return process;
    }

    private void printFailureLogToCommandline(File logFile) throws IOException, FileNotFoundException {
        try (BufferedReader br = new BufferedReader(new FileReader(logFile));){
            String line;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        }
    }
}

