/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.utils;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;

public class EnvironmentVariables
implements Serializable {
    private static final long serialVersionUID = 6287969989033845334L;
    private final Map<String, String> environmentVariables = new TreeMap<String, String>();
    private final String properties;

    public EnvironmentVariables(String properties) {
        this.properties = properties != null ? properties : "";
    }

    public EnvironmentVariables() {
        this.properties = "";
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public String getProperties() {
        return this.properties;
    }

    public String fetchMavenCall(File projectFolder) {
        if (projectFolder != null) {
            if (!EnvironmentVariables.isWindows()) {
                File potentialWrapper = new File(projectFolder, "mvnw");
                if (potentialWrapper.exists() && potentialWrapper.canExecute()) {
                    return "./mvnw";
                }
            } else {
                File potentialWrapper = new File(projectFolder, "mvnw.cmd");
                if (potentialWrapper.exists()) {
                    return potentialWrapper.getAbsolutePath();
                }
            }
        }
        return this.fetchMavenCall();
    }

    private String fetchMavenCall() {
        String mvnCall = this.environmentVariables.containsKey("MVN_CMD") ? this.environmentVariables.get("MVN_CMD") : (!EnvironmentVariables.isWindows() ? "mvn" : "mvn.cmd");
        return mvnCall;
    }

    public static String fetchMavenCallGeneric() {
        String mvnCall = !EnvironmentVariables.isWindows() ? "mvn" : "mvn.cmd";
        return mvnCall;
    }

    public static String fetchGradleCall() {
        String gradleCall = !EnvironmentVariables.isWindows() ? "./gradlew" : "gradlew.bat";
        return gradleCall;
    }

    public static String fetchAdbCall() {
        String adbCall = new File(System.getenv("ANDROID_SDK_ROOT"), "platform-tools/adb").getAbsolutePath();
        return adbCall;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean isLinux() {
        return !System.getProperty("os.name").startsWith("Windows") && !System.getProperty("os.name").startsWith("Mac");
    }

    public static int getVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }
}

