/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.utils;

import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.testtransformation.JUnitTestShortener;
import de.dagere.peass.testtransformation.JUnitTestTransformer;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.List;
import net.kieker.sourceinstrumentation.AllowedKiekerRecord;
import net.kieker.sourceinstrumentation.InstrumentationConfiguration;
import net.kieker.sourceinstrumentation.instrument.InstrumentKiekerSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class KoPeMeExecutor
extends TestExecutor {
    private static final Logger LOG = LogManager.getLogger(KoPeMeExecutor.class);
    protected final JUnitTestTransformer testTransformer;

    public KoPeMeExecutor(PeassFolders folders, JUnitTestTransformer testTransformer, EnvironmentVariables env) {
        super(folders, testTransformer, env);
        this.testTransformer = testTransformer;
    }

    public void transformTests() {
        List<File> modules = this.getModules().getModules();
        this.testTransformer.determineVersions(modules);
        this.testTransformer.transformTests();
    }

    protected String getTestGoal() {
        ExecutionConfig executionConfig = this.testTransformer.getConfig().getExecutionConfig();
        String testGoal = this.isAndroid ? (executionConfig.getTestGoal() != null ? executionConfig.getTestGoal() : "testRelease") : (executionConfig.getTestGoal() != null ? executionConfig.getTestGoal() : "test");
        return testGoal;
    }

    protected abstract void runTest(File var1, File var2, TestMethodCall var3, String var4, long var5);

    protected void runMethod(File logFolder, TestMethodCall test, File moduleFolder, long timeout) {
        try (JUnitTestShortener shortener = new JUnitTestShortener(this.testTransformer, moduleFolder, (Type)test.toEntity(), test.getMethod());){
            if (this.testTransformer.getConfig().isDirectlyMeasureKieker()) {
                File fileToInstrument = shortener.getCalleeClazzFile();
                boolean strictMode = false;
                if (this.testTransformer.getConfig().getExecutionConfig().isUseAnbox()) {
                    strictMode = true;
                }
                HashSet<CallSite> includedPatterns = new HashSet<CallSite>();
                includedPatterns.add((CallSite)((Object)("* " + test.getClazz() + "." + test.getMethod() + "()")));
                InstrumentationConfiguration configuration = new InstrumentationConfiguration(AllowedKiekerRecord.DURATION, true, false, false, includedPatterns, null, false, this.testTransformer.getConfig().getRepetitions(), false, strictMode);
                InstrumentKiekerSource instrumenter = new InstrumentKiekerSource(configuration);
                instrumenter.instrument(fileToInstrument);
            }
            LOG.info("Cleaning...");
            File cleanFile = this.getCleanLogFile(logFolder, test);
            this.clean(cleanFile);
            File methodLogFile = this.getMethodLogFile(logFolder, test);
            this.runTest(moduleFolder, methodLogFile, test, test.getClazz(), timeout);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public JUnitTestTransformer getTestTransformer() {
        return this.testTransformer;
    }
}

