/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.utils;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ProjectModules {
    private final List<File> modules;
    private final Map<File, String> artifactIds = new HashMap<File, String>();

    public ProjectModules(List<File> modules) {
        this.modules = modules;
    }

    public ProjectModules(File current) {
        this.modules = new LinkedList<File>();
        this.modules.add(current);
    }

    public List<File> getModules() {
        return this.modules;
    }

    public Map<File, String> getArtifactIds() {
        return this.artifactIds;
    }

    public List<File> getParents(File moduleFile) {
        LinkedList<File> parents = new LinkedList<File>();
        for (File potentialParent : this.modules) {
            String potentialParentPath = potentialParent.getAbsolutePath();
            String moduleAbsolutePath = moduleFile.getAbsolutePath();
            if (!moduleAbsolutePath.contains(potentialParentPath) || potentialParent.equals(moduleFile)) continue;
            parents.add(potentialParent);
        }
        return parents;
    }
}

