/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.utils;

import de.dagere.peass.testtransformation.JUnitVersions;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.model.Dependency;

public class RequiredDependency {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String scope;
    private final String classifier;

    public RequiredDependency(String groupId, String artifactId, String version, String scope, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.scope = scope;
        this.classifier = classifier;
    }

    public static List<RequiredDependency> getAll(JUnitVersions versions) {
        LinkedList<RequiredDependency> all = new LinkedList<RequiredDependency>();
        if (versions.isJunit3()) {
            all.add(new RequiredDependency("de.dagere.kopeme", "kopeme-junit3", "1.4.4", "", null));
        }
        if (versions.isJunit4()) {
            all.add(new RequiredDependency("de.dagere.kopeme", "kopeme-junit4", "1.4.4", "", null));
        }
        if (versions.isJunit5()) {
            all.add(new RequiredDependency("de.dagere.kopeme", "kopeme-junit5", "1.4.4", "", null));
        }
        all.add(new RequiredDependency("com.fasterxml.jackson.core", "jackson-databind", "2.19.1", "", null));
        all.add(new RequiredDependency("net.kieker-monitoring", "kieker", "2.0.2", "", null));
        all.add(new RequiredDependency("net.kieker-monitoring", "kieker", "2.0.2", "", "aspectj"));
        return all;
    }

    public String getGradleDependency() {
        String gradleDependencyString = this.classifier == null ? this.groupId + ":" + this.artifactId + ":" + this.version : this.groupId + ":" + this.artifactId + ":" + this.version + ":" + this.classifier;
        return gradleDependencyString;
    }

    public Dependency getMavenDependency() {
        Dependency dependency = new Dependency();
        dependency.setGroupId(this.groupId);
        dependency.setArtifactId(this.artifactId);
        dependency.setVersion(this.version);
        dependency.setScope(this.scope);
        if (this.classifier != null) {
            dependency.setClassifier(this.classifier);
        }
        return dependency;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getScope() {
        return this.scope;
    }

    public String getClassifier() {
        return this.classifier;
    }
}

