/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.execution.utils;

import de.dagere.nodeDiffDetector.config.FolderConfig;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.nodeDiffDetector.typeFinding.TypeFileFinder;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.execution.kieker.KiekerEnvironmentPreparer;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.ProjectModules;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.testtransformation.TestTransformer;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TestExecutor {
    private static final Logger LOG = LogManager.getLogger(TestExecutor.class);
    public static final String GENERATED_TEST_NAME = "GeneratedTest";
    protected final PeassFolders folders;
    protected File lastTmpFile;
    protected int jdk_version = 8;
    protected final TestTransformer testTransformer;
    protected List<String> existingClasses;
    protected Set<String> includedMethodPattern;
    protected boolean isAndroid;
    protected final EnvironmentVariables env;
    private final List<String> aborted = new LinkedList<String>();

    public TestExecutor(PeassFolders folders, TestTransformer testTransformer, EnvironmentVariables env) {
        this.folders = folders;
        this.testTransformer = testTransformer;
        this.env = env;
    }

    public void setJDKVersion(int jdk_version) {
        this.jdk_version = jdk_version;
    }

    public int getJDKVersion() {
        return this.jdk_version;
    }

    public abstract void prepareKoPeMeExecution(File var1);

    public abstract void executeTest(TestMethodCall var1, File var2, long var3);

    public void cleanAboveSize(File folderToClean, String ending) {
        for (File file : FileUtils.listFiles((File)folderToClean, (IOFileFilter)new WildcardFileFilter("*." + ending), (IOFileFilter)TrueFileFilter.INSTANCE)) {
            long size = file.length() / 0x100000L;
            LOG.debug("File: {} Size: {} MB", (Object)file, (Object)size);
            if (size <= (long)this.testTransformer.getConfig().getMaxLogSizeInMb()) continue;
            LOG.debug("Deleting file.");
            file.delete();
        }
    }

    protected File getCleanLogFile(File logFolder, TestMethodCall test) {
        File clazzLogFolder = this.getClazzLogFolder(logFolder, (TestCase)test);
        File logFile = new File(clazzLogFolder, "clean" + File.separator + test.getMethodWithParams() + ".txt");
        if (!logFile.getParentFile().exists()) {
            logFile.getParentFile().mkdir();
        }
        return logFile;
    }

    protected File getMethodLogFile(File logFolder, TestMethodCall test) {
        File clazzLogFolder = this.getClazzLogFolder(logFolder, (TestCase)test);
        File logFile = new File(clazzLogFolder, test.getMethodWithParams() + ".txt");
        return logFile;
    }

    private File getClazzLogFolder(File logFolder, TestCase test) {
        File clazzLogFolder;
        if (test.getModule() != null && !"".equals(test.getModule())) {
            File moduleFolder = new File(logFolder, test.getModule());
            if (!moduleFolder.exists()) {
                moduleFolder.mkdir();
            }
            clazzLogFolder = new File(moduleFolder, "log_" + test.getClazz());
        } else {
            clazzLogFolder = new File(logFolder, "log_" + test.getClazz());
        }
        if (!clazzLogFolder.exists()) {
            clazzLogFolder.mkdir();
        }
        return clazzLogFolder;
    }

    protected void prepareKiekerSource() {
        if (this.testTransformer.getConfig().getKiekerConfig().isUseKieker()) {
            KiekerEnvironmentPreparer kiekerEnvironmentPreparer = new KiekerEnvironmentPreparer(this.includedMethodPattern, this.existingClasses, this.folders, this.testTransformer, this.getModules().getModules());
            kiekerEnvironmentPreparer.prepareKieker();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void execute(String testname, long timeoutInSeconds, Process process) {
        if (timeoutInSeconds == -1L) {
            LOG.info("Executing without timeout!");
            try {
                process.waitFor();
                return;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (timeoutInSeconds <= 0L) throw new RuntimeException("Illegal timeout: " + timeoutInSeconds);
        try {
            LOG.debug("Executing: {} Timeout: {}", (Object)testname, (Object)timeoutInSeconds);
            process.waitFor(timeoutInSeconds, TimeUnit.SECONDS);
            if (!process.isAlive()) return;
            LOG.debug("Killing: {}", (Object)testname);
            process.destroyForcibly().waitFor();
            this.aborted.add(testname);
            FileUtils.writeStringToFile((File)new File(this.folders.getFullMeasurementFolder(), "aborted.txt"), (String)this.aborted.toString(), (Charset)Charset.defaultCharset());
            return;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract boolean doesBuildfileExist();

    public abstract boolean isCommitRunning(String var1);

    public void deleteTemporaryFiles() {
        try {
            if (this.lastTmpFile != null && this.lastTmpFile.exists()) {
                File[] tmpKiekerStuff;
                for (File kiekerFolder : tmpKiekerStuff = this.lastTmpFile.listFiles((FilenameFilter)new WildcardFileFilter("kieker*"))) {
                    LOG.debug("Deleting: {}", (Object)kiekerFolder.getAbsolutePath());
                    FileUtils.deleteDirectory((File)kiekerFolder);
                }
                FileUtils.deleteDirectory((File)this.lastTmpFile);
            }
        }
        catch (IOException | IllegalArgumentException e) {
            LOG.info("Problems deleting last temp file..");
            e.printStackTrace();
        }
    }

    public abstract ProjectModules getModules();

    public List<String> getExistingClasses() {
        return this.existingClasses;
    }

    protected abstract void clean(File var1) throws IOException, InterruptedException;

    public void fetchClasses(ModuleClassMapping mapping) {
        this.existingClasses = new LinkedList<String>();
        this.existingClasses.addAll(mapping.getAllClasses());
    }

    public void loadClasses() {
        this.existingClasses = new LinkedList<String>();
        for (File module : this.getModules().getModules()) {
            ExecutionConfig executionConfig = this.testTransformer.getConfig().getExecutionConfig();
            TypeFileFinder finder = new TypeFileFinder((FolderConfig)executionConfig);
            List currentClasses = finder.getTypes(module);
            this.existingClasses.addAll(currentClasses);
        }
    }

    public File getProjectFolder() {
        return this.folders.getProjectFolder();
    }

    public PeassFolders getFolders() {
        return this.folders;
    }

    public boolean isAndroid() {
        return false;
    }

    public void setIncludedMethods(Set<String> includedMethodPattern) {
        this.includedMethodPattern = includedMethodPattern;
    }

    public TestTransformer getTestTransformer() {
        return this.testTransformer;
    }

    public EnvironmentVariables getEnv() {
        return this.env;
    }
}

