/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.folders;

import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.folders.PeassFolders;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class CauseSearchFolders
extends PeassFolders {
    public static final String RCA_RESULT_FOLDERNAME = "treeMeasurementResults";
    private final File levelFolder;
    private final File archivedFolder;
    private final File treeMeasurementResultsFolder;
    private final File treeCacheFolder;
    private final File rcaFolder;

    public CauseSearchFolders(File folder) {
        super(folder);
        this.rcaFolder = new File(this.peassFolder, "rca");
        this.levelFolder = new File(this.rcaFolder, "level");
        this.levelFolder.mkdir();
        this.archivedFolder = new File(this.rcaFolder, "archived");
        this.archivedFolder.mkdir();
        File candidate = new File(this.rcaFolder, "tree");
        if (candidate.exists()) {
            this.treeMeasurementResultsFolder = new File(this.rcaFolder, RCA_RESULT_FOLDERNAME);
            candidate.renameTo(this.treeMeasurementResultsFolder);
        } else {
            this.treeMeasurementResultsFolder = new File(this.rcaFolder, RCA_RESULT_FOLDERNAME);
            this.treeMeasurementResultsFolder.mkdir();
        }
        File cacheCandidate = new File(this.rcaFolder, "treeCache");
        if (cacheCandidate.exists()) {
            this.treeCacheFolder = cacheCandidate;
        } else {
            this.treeCacheFolder = new File(this.rcaFolder, "treeStructureCache");
            this.treeCacheFolder.mkdir();
        }
        this.copyScripts();
    }

    private void copyScripts() {
        try {
            URL getProgressScript = CauseSearchFolders.class.getClassLoader().getResource("copy/getProgress.sh");
            File getProgressFile = new File(this.peassFolder, "getProgress.sh");
            FileUtils.copyURLToFile((URL)getProgressScript, (File)getProgressFile);
            getProgressFile.setExecutable(true);
            URL clearRcaScript = CauseSearchFolders.class.getClassLoader().getResource("copy/clearRCAMeasurement.sh");
            File clearRcaFile = new File(this.peassFolder, "clearRCA.sh");
            FileUtils.copyURLToFile((URL)clearRcaScript, (File)clearRcaFile);
            clearRcaFile.setExecutable(true);
            URL valueReadingScript = CauseSearchFolders.class.getClassLoader().getResource("copy/getIntermediaryValues.sh");
            File valueReadingFile = new File(this.peassFolder, "rca" + File.separator + "getIntermediaryValues.sh");
            FileUtils.copyURLToFile((URL)valueReadingScript, (File)valueReadingFile);
            valueReadingFile.setExecutable(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public File getDetailResultFolder() {
        return this.levelFolder;
    }

    public File getArchiveResultFolder(String commit, TestMethodCall testcase) {
        File folder = new File(this.archivedFolder, commit + File.separator + testcase.getClazz() + File.separator + testcase.getMethodWithParams());
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    public File getArchivedFolder() {
        return this.archivedFolder;
    }

    public File getRcaTreeFolder() {
        return this.treeMeasurementResultsFolder;
    }

    public File getRcaFolder() {
        return this.rcaFolder;
    }

    public List<File> getRcaMethodFiles() {
        LinkedList<File> rcaMethodFiles = new LinkedList<File>();
        for (File commitFile : this.treeMeasurementResultsFolder.listFiles()) {
            for (File testclazzFile : commitFile.listFiles()) {
                for (File methodFile : testclazzFile.listFiles((FileFilter)new WildcardFileFilter("*.json"))) {
                    rcaMethodFiles.add(methodFile);
                }
            }
        }
        return rcaMethodFiles;
    }

    public File getRcaTreeFolder(String commit, TestCase testcase) {
        File treeDataFolder = new File(this.treeMeasurementResultsFolder, commit + File.separator + testcase.getShortClazz());
        return treeDataFolder;
    }

    public File getRcaTreeFile(String commit, TestMethodCall testcase) {
        File treeDataFolder = this.getRcaTreeFolder(commit, (TestCase)testcase);
        File treeFile = new File(treeDataFolder, testcase.getMethodWithParams() + ".json");
        return treeFile;
    }

    public File getRcaTreeFileDetails(String commit, TestMethodCall testcase) {
        File treeDataFolder = this.getRcaTreeFolder(commit, (TestCase)testcase);
        File treeFile = new File(treeDataFolder, "details" + File.separator + testcase.getMethodWithParams() + ".json");
        return treeFile;
    }

    public File getTreeCacheFolder(String commit, TestMethodCall testcase) {
        File folder = this.getExistingTreeCacheFolder(commit, testcase);
        folder.mkdirs();
        return folder;
    }

    public File getExistingTreeCacheFolder(String commit, TestMethodCall testcase) {
        File folder = new File(this.treeCacheFolder, commit + File.separator + testcase.getClazz() + File.separator + testcase.getMethodWithParams());
        return folder;
    }
}

