/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.folders;

import de.dagere.nodeDiffDetector.config.SourceCodeFolders;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.dependency.traces.TemporaryProjectFolderUtil;
import de.dagere.peass.folders.VMExecutionLogFolders;
import de.dagere.peass.vcs.VersionControlSystem;
import java.io.File;
import java.io.FileFilter;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PeassFolders
implements SourceCodeFolders {
    public static final String CLEAN_FOLDER_NAME = "clean";
    private static final Logger LOG = LogManager.getLogger(PeassFolders.class);
    public static final String MEASUREMENTS = "measurements";
    public static final String PEASS_POSTFIX = "_peass";
    public static final String PEASS_FULL_POSTFIX = "_fullPeass";
    protected final File projectFolder;
    protected final File fullResultFolder;
    private final File tempResultFolder;
    private final File tempProjectFolder;
    private final File tempFolder;
    private final File kiekerTemp;
    private final VMExecutionLogFolders logFolders;
    private final File oldSourceFolder;
    private final File measurementsFolder;
    private final File cleanFolder;
    protected final File cleanNativeFolder;
    private final File debugFolder;
    private final VersionControlSystem vcs;
    protected final File peassFolder;
    private final String projectName;

    public static File getPeassFolder(File projectFolder) {
        File peassFolder = new File(projectFolder, ".." + File.separator + projectFolder.getName() + PEASS_POSTFIX);
        return peassFolder;
    }

    public PeassFolders(File folder, String projectName) {
        this.projectName = projectName;
        if (!folder.getName().endsWith(PEASS_POSTFIX)) {
            this.projectFolder = folder;
            this.peassFolder = new File(this.projectFolder.getParentFile(), this.projectFolder.getName() + PEASS_POSTFIX);
            if (!this.peassFolder.exists()) {
                this.peassFolder.mkdir();
            }
            this.vcs = VersionControlSystem.getVersionControlSystem(this.projectFolder);
        } else {
            this.projectFolder = null;
            this.vcs = null;
            this.peassFolder = folder;
        }
        this.logFolders = new VMExecutionLogFolders(this.peassFolder);
        this.oldSourceFolder = new File(this.peassFolder, "lastSources");
        this.fullResultFolder = new File(this.peassFolder, "measurementsFull");
        this.fullResultFolder.mkdir();
        this.tempFolder = new File(this.peassFolder, "temp");
        this.cleanFolder = new File(this.peassFolder, CLEAN_FOLDER_NAME);
        this.cleanNativeFolder = new File(this.cleanFolder, "native");
        this.debugFolder = new File(this.peassFolder, "debug");
        this.measurementsFolder = new File(this.fullResultFolder, MEASUREMENTS);
        this.measurementsFolder.mkdir();
        this.tempResultFolder = new File(this.peassFolder, "measurementsTemp");
        this.tempResultFolder.mkdir();
        this.kiekerTemp = new File(this.peassFolder, "kiekerTemp");
        this.tempProjectFolder = new File(this.peassFolder, "projectTemp");
    }

    public PeassFolders(File folder) {
        this(folder, folder != null ? folder.getName() : null);
    }

    public File getPeassFolder() {
        return this.peassFolder;
    }

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public File getCleanFolder() {
        return this.cleanFolder;
    }

    public File getNativeCleanFolder() {
        return this.cleanNativeFolder;
    }

    public File getDependencyLogFolder() {
        return this.logFolders.getDependencyLogFolder();
    }

    public File getTwiceRunningLogFolder() {
        return this.logFolders.getTwiceRunningLogFolder();
    }

    public File getDependencyLogSuccessRunFile(String commit) {
        File commitFolder = new File(this.getDependencyLogFolder(), commit);
        if (!commitFolder.exists()) {
            commitFolder.mkdir();
        }
        return new File(commitFolder, "testRunning.log");
    }

    public File getMeasureLogFolder() {
        return this.logFolders.getMeasureLogFolder();
    }

    public File getTreeLogFolder() {
        return this.logFolders.getTreeLogFolder();
    }

    public File getRCALogFolder() {
        return this.logFolders.getRCALogFolder();
    }

    public File getExistingMeasureLogFolder(String commit, TestMethodCall testcase) {
        File testLogFolder = new File(this.getMeasureLogFolder(), commit + File.separator + testcase.getClazz() + File.separator + testcase.getMethod());
        if (testLogFolder.exists()) {
            return testLogFolder;
        }
        return null;
    }

    public File getMeasureLogFolder(String commit, TestMethodCall testcase) {
        File testLogFolder = new File(this.getMeasureLogFolder(), commit + File.separator + testcase.getClazz() + File.separator + testcase.getMethod());
        testLogFolder.mkdirs();
        return testLogFolder;
    }

    public File getExistingRCALogFolder(String commit, TestMethodCall testcase, int level) {
        File testLogFolder = new File(this.getRCALogFolder(), commit + File.separator + testcase.getClazz() + File.separator + testcase.getMethod() + File.separator + level);
        return testLogFolder;
    }

    public File getRCALogFolder(String commit, TestMethodCall testcase, int level) {
        File testLogFolder = new File(this.getRCALogFolder(), commit + File.separator + testcase.getClazz() + File.separator + testcase.getMethod() + File.separator + level);
        testLogFolder.mkdirs();
        return testLogFolder;
    }

    public File getOldSources() {
        if (!this.oldSourceFolder.exists()) {
            this.oldSourceFolder.mkdir();
        }
        return this.oldSourceFolder;
    }

    public File getFullMeasurementFolder() {
        return this.fullResultFolder;
    }

    public File getProgressFile() {
        return new File(this.fullResultFolder, "progress.txt");
    }

    public File getTempMeasurementFolder() {
        return this.tempResultFolder;
    }

    public List<File> findTempClazzFolder(TestCase testcase) {
        String expectedFolderName = "*" + testcase.getClazz();
        System.out.println("Testcase: " + String.valueOf(testcase) + " " + expectedFolderName);
        WildcardFileFilter folderFilter = new WildcardFileFilter(expectedFolderName);
        return this.findTempClazzFolder(this.tempResultFolder, (FileFilter)folderFilter);
    }

    private List<File> findTempClazzFolder(File baseFolder, FileFilter folderFilter) {
        LinkedList<File> files = new LinkedList<File>();
        LOG.trace("Searching in {} {}", (Object)baseFolder, (Object)baseFolder.exists());
        for (File subfolder : baseFolder.listFiles()) {
            if (!subfolder.isDirectory()) continue;
            if (folderFilter.accept(subfolder)) {
                files.add(subfolder);
                continue;
            }
            files.addAll(this.findTempClazzFolder(subfolder, folderFilter));
        }
        return files;
    }

    public File getDetailResultFolder() {
        return this.measurementsFolder;
    }

    public File getSummaryFile(TestMethodCall testcase) {
        File fullResultFileXML;
        String shortClazzName = testcase.getShortClazz();
        File fullResultFile = testcase.getParams() != null ? ((fullResultFileXML = new File(this.fullResultFolder, shortClazzName + "_" + testcase.getMethod() + "(" + testcase.getParams() + ").xml")).exists() ? fullResultFileXML : new File(this.fullResultFolder, shortClazzName + "_" + testcase.getMethod() + "(" + testcase.getParams() + ").json")) : ((fullResultFileXML = new File(this.fullResultFolder, shortClazzName + "_" + testcase.getMethod() + ".xml")).exists() ? fullResultFileXML : new File(this.fullResultFolder, shortClazzName + "_" + testcase.getMethod() + ".json"));
        return fullResultFile;
    }

    public File getFullResultFolder(TestCase testcase, String mainCommit, String commit) {
        File compareCommitFolder;
        File destFolder = new File(this.getDetailResultFolder(), testcase.getClazz());
        LOG.trace("Creating: {} Commit: {} Class: {} ", (Object)destFolder, (Object)mainCommit, (Object)testcase.getClazz());
        File currentCommitFolder = new File(destFolder, mainCommit);
        if (!currentCommitFolder.exists()) {
            currentCommitFolder.mkdir();
        }
        if (!(compareCommitFolder = new File(currentCommitFolder, commit)).exists()) {
            compareCommitFolder.mkdir();
        }
        return compareCommitFolder;
    }

    public File getResultFile(TestMethodCall testcase, int vmid, String commit, String mainCommit) {
        File compareCommitFolder = this.getFullResultFolder((TestCase)testcase, mainCommit, commit);
        String xmlFileName = PeassFolders.getXMLFileName(testcase, commit, vmid);
        File destFile = new File(compareCommitFolder, xmlFileName);
        return destFile;
    }

    public static String getRelativeFullResultPath(TestMethodCall testcase, String mainCommit, String commit, int vmid) {
        String filename = PeassFolders.getXMLFileName(testcase, commit, vmid);
        String start = testcase.getClazz() + File.separator + mainCommit + File.separator + commit + File.separator + filename;
        return start;
    }

    private static String getXMLFileName(TestMethodCall testcase, String commit, int vmid) {
        String filename = testcase.getParams() != null ? testcase.getMethod() + "(" + testcase.getParams() + ")_" + vmid + "_" + commit + ".json" : testcase.getMethod() + "_" + vmid + "_" + commit + ".json";
        return filename;
    }

    public File getTempProjectFolder() {
        if (!this.tempProjectFolder.exists()) {
            this.tempProjectFolder.mkdir();
        }
        return this.tempProjectFolder;
    }

    public File getKiekerTempFolder() {
        if (!this.kiekerTemp.exists()) {
            this.kiekerTemp.mkdir();
        }
        return this.kiekerTemp;
    }

    public File getTempDir() {
        if (!this.tempFolder.exists()) {
            this.tempFolder.mkdir();
        }
        return this.tempFolder;
    }

    public File getDebugFolder() {
        if (!this.debugFolder.exists()) {
            this.debugFolder.mkdir();
        }
        return this.debugFolder;
    }

    public PeassFolders getTempFolder(String name, String gitCryptKey) {
        File nowFolder = new File(this.getTempProjectFolder(), name);
        PeassFolders folders = TemporaryProjectFolderUtil.cloneForcefully(this, nowFolder, this.logFolders, gitCryptKey);
        return folders;
    }

    public VersionControlSystem getVCS() {
        return this.vcs;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public File getReductionFile(TestMethodCall testcase) {
        File clazzFolder;
        File reductionFolder = new File(this.peassFolder, "reductions");
        if (!reductionFolder.exists()) {
            reductionFolder.mkdirs();
        }
        if (!(clazzFolder = new File(reductionFolder, testcase.getClazz())).exists()) {
            clazzFolder.mkdirs();
        }
        return new File(clazzFolder, testcase.getMethodWithParams() + ".json");
    }

    public VMExecutionLogFolders getLogFolders() {
        return this.logFolders;
    }
}

