/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.folders;

import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.folders.CauseSearchFolders;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultsFolders {
    public static final String RCA_MAPPING_FILE_NAME = "rcaMapping.json";
    private static final Logger LOG = LogManager.getLogger(ResultsFolders.class);
    public static final String MEASUREMENT_PREFIX = "measurement_";
    public static final String STATIC_SELECTION_PREFIX = "staticTestSelection_";
    public static final String TRACE_SELECTION_PREFIX = "traceTestSelection_";
    private final File resultFolder;
    private final String projectName;

    public ResultsFolders(File resultFolder, String projectName) {
        this.resultFolder = resultFolder;
        resultFolder.mkdirs();
        this.projectName = projectName;
    }

    public File getStaticTestSelectionFile() {
        File oldFileName = new File(this.resultFolder, "deps_" + this.projectName + ".json");
        if (oldFileName.exists()) {
            return oldFileName;
        }
        return new File(this.resultFolder, STATIC_SELECTION_PREFIX + this.projectName + ".json");
    }

    public File getTraceTestSelectionFile() {
        File oldFileName = new File(this.resultFolder, "execute_" + this.projectName + ".json");
        if (oldFileName.exists()) {
            return oldFileName;
        }
        return new File(this.resultFolder, TRACE_SELECTION_PREFIX + this.projectName + ".json");
    }

    public File getCoverageSelectionFile() {
        return new File(this.resultFolder, "coverageSelection_" + this.projectName + ".json");
    }

    public File getCoverageInfoFile() {
        return new File(this.resultFolder, "coverageInfo_" + this.projectName + ".json");
    }

    public File getTwiceExecutableFile() {
        return new File(this.resultFolder, "twiceExecutable_" + this.projectName + ".json");
    }

    public File getCommitMetadataFile() {
        return new File(this.resultFolder, "commits.json");
    }

    public File getStatisticsFile() {
        return new File(this.resultFolder, "statistics.json");
    }

    public File getChangeFile() {
        return new File(this.resultFolder, "changes.json");
    }

    public File getRCAMappingFile() {
        return new File(this.resultFolder, RCA_MAPPING_FILE_NAME);
    }

    public File getRtsLogFolder() {
        File folder = new File(this.resultFolder, "rtsLogs");
        return folder;
    }

    public File getSourceReadLogFolder() {
        File folder = new File(this.resultFolder, "sourceReadLogs");
        return folder;
    }

    public File getRTSLogFile(String commit, String commitOld) {
        File folder = this.getRtsLogFolder();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File logFile = new File(folder, commit + "_" + commitOld + ".txt");
        return logFile;
    }

    public File getSourceReadLogFile(String commit, String commitOld) {
        File folder = this.getSourceReadLogFolder();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File logFile = new File(folder, commit + "_" + commitOld + ".txt");
        return logFile;
    }

    public File getMeasurementLogFolder() {
        File folder = new File(this.resultFolder, "measurementLogs");
        return folder;
    }

    public File getMeasurementLogFile(String commit, String commitOld) {
        File folder = this.getMeasurementLogFolder();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File logFile = new File(folder, commit + "_" + commitOld + ".txt");
        return logFile;
    }

    public File getRCALogFolder() {
        File folder = new File(this.resultFolder, "rcaLogs");
        return folder;
    }

    public File getRCALogFile(String commit, String commitOld) {
        File folder = this.getRCALogFolder();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File logFile = new File(folder, commit + "_" + commitOld + ".txt");
        return logFile;
    }

    public File getCommitFullResultsFolder(String commit, String commitOld) {
        if (commit == null) {
            throw new RuntimeException("Commit must not be null!");
        }
        if (commitOld == null) {
            throw new RuntimeException("CommitOld must not be null!");
        }
        File fullResultsVersion = new File(this.resultFolder, MEASUREMENT_PREFIX + commit + "_" + commitOld);
        return fullResultsVersion;
    }

    public File getViewFolder() {
        File viewFolder = new File(this.resultFolder, "views_" + this.projectName);
        viewFolder.mkdirs();
        return viewFolder;
    }

    public File getPropertiesFile() {
        return new File(this.getPropertiesFolder(), "properties.json");
    }

    public File getCommitDiffFolder(String commit) {
        File diffsFolder = new File(this.getCommitViewFolder(commit), "diffs");
        diffsFolder.mkdirs();
        return diffsFolder;
    }

    public File getCommitViewFolder(String commit) {
        File commitViewFolder = new File(this.getViewFolder(), "view_" + commit);
        commitViewFolder.mkdirs();
        return commitViewFolder;
    }

    public File getViewMethodDir(String commit, TestMethodCall testcase) {
        File methodDir = new File(this.getClazzDir(commit, (TestCase)testcase), testcase.getMethodWithParams());
        if (!methodDir.exists()) {
            boolean create = methodDir.mkdirs();
            LOG.debug("Created directory {} Success: {}", (Object)methodDir.getAbsolutePath(), (Object)create);
        } else {
            LOG.debug("Directory {} already existing", (Object)methodDir.getAbsolutePath());
        }
        return methodDir;
    }

    public File getClazzDir(String commit, TestCase testcase) {
        String clazzDirName;
        File clazzDir;
        File viewResultsFolder = new File(this.getViewFolder(), "view_" + commit);
        if (!viewResultsFolder.exists()) {
            viewResultsFolder.mkdir();
        }
        if (!(clazzDir = new File(viewResultsFolder, clazzDirName = testcase.getModule() != null && !testcase.getModule().equals("") ? testcase.getModule() + "\u00a7" + testcase.getClazz() : testcase.getClazz())).exists()) {
            clazzDir.mkdir();
        }
        return clazzDir;
    }

    public File getPropertiesFolder() {
        File propertyFolder = new File(this.resultFolder, "properties_" + this.projectName);
        propertyFolder.mkdirs();
        return propertyFolder;
    }

    public File getCommitFullResultsFolder(MeasurementConfig measurementConfig) {
        return this.getCommitFullResultsFolder(measurementConfig.getFixedCommitConfig().getCommit(), measurementConfig.getFixedCommitConfig().getCommitOld());
    }

    public CauseSearchFolders getPeassFolders() {
        File folder = new File(this.resultFolder, this.projectName);
        if (folder.exists()) {
            return new CauseSearchFolders(folder);
        }
        return null;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public File getResultFolder() {
        return this.resultFolder;
    }
}

